/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;

final class Inet4Network
implements Comparable<Inet4Network> {
    private final Inet4Address address;
    private final int bits;
    private final long start;
    private final long end;

    private Inet4Network(Inet4Address address, int bits) {
        this.address = address;
        this.bits = bits;
        this.start = Inet4Network.addressToLong(this.getStartingAddress());
        this.end = Inet4Network.addressToLong(this.getEndingAddress());
    }

    public Inet4Address getStartingAddress() {
        return this.address;
    }

    public Inet4Address getEndingAddress() {
        int start = InetAddresses.coerceToInteger((InetAddress)this.address);
        int length = this.bits == 0 ? 0 : 1 << 32 - this.bits;
        int end = start + length - 1;
        return InetAddresses.fromInteger((int)end);
    }

    public int getBits() {
        return this.bits;
    }

    public boolean containsAddress(Inet4Address address) {
        long ip = Inet4Network.addressToLong(address);
        return ip >= this.start && ip <= this.end;
    }

    public String toString() {
        return this.address.getHostAddress() + "/" + this.bits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Inet4Network that = (Inet4Network)o;
        if (this.bits != that.bits) {
            return false;
        }
        return this.address.equals(that.address);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.bits;
        return result;
    }

    @Override
    public int compareTo(Inet4Network o) {
        if (this.start != o.start) {
            return this.start < o.start ? -1 : 1;
        }
        if (this.bits != o.bits) {
            return this.bits < o.bits ? -1 : 1;
        }
        return 0;
    }

    public static Inet4Network fromCidr(String cidr) {
        String[] parts = cidr.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid CIDR format: " + cidr);
        }
        Inet4Address address = (Inet4Address)InetAddresses.forString((String)parts[0]);
        int bits = Integer.parseInt(parts[1]);
        return Inet4Network.fromAddress(address, bits);
    }

    public static Inet4Network fromAddress(Inet4Address address, int bits) {
        if (bits < 0 || bits > 32) {
            throw new IllegalArgumentException("invalid prefix size: " + bits);
        }
        int mask = bits == 0 ? 0 : -1 << 32 - bits;
        int ip = InetAddresses.coerceToInteger((InetAddress)address);
        if ((ip & mask) != ip) {
            throw new IllegalArgumentException("invalid prefix for prefix size: " + bits);
        }
        return new Inet4Network(address, bits);
    }

    public static Inet4Network truncatedFromAddress(Inet4Address address, int bits) {
        int mask = bits == 0 ? 0 : -1 << 32 - bits;
        int ip = InetAddresses.coerceToInteger((InetAddress)address);
        return Inet4Network.fromAddress(InetAddresses.fromInteger((int)(ip & mask)), bits);
    }

    static long addressToLong(Inet4Address address) {
        return (long)InetAddresses.coerceToInteger((InetAddress)address) & 0xFFFFFFFFL;
    }
}

