/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationFactory;
import java.lang.annotation.Annotation;

public class ConfigurationModule
implements Module {
    private final ConfigurationFactory configurationFactory;

    public ConfigurationModule(ConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(ConfigurationFactory.class).toInstance((Object)this.configurationFactory);
    }

    private static StackTraceElement getCaller() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        boolean foundThisClass = false;
        for (StackTraceElement element : stack) {
            if (!foundThisClass) {
                if (!element.getClassName().equals(ConfigurationModule.class.getName())) continue;
                foundThisClass = true;
                continue;
            }
            if (element.getClassName().equals(ConfigurationModule.class.getName())) continue;
            return element;
        }
        return null;
    }

    @Deprecated
    public static AnnotatedBindingBuilder bindConfig(Binder binder) {
        return new AnnotatedBindingBuilder(binder.withSource((Object)ConfigurationModule.getCaller()));
    }

    public static class ConfigBindingBuilder {
        protected final Binder binder;
        protected final Class<? extends Annotation> annotationType;
        protected final Annotation annotation;
        protected final String prefix;

        public ConfigBindingBuilder(Binder binder, Class<? extends Annotation> annotationType, Annotation annotation, String prefix) {
            this.binder = binder;
            this.annotationType = annotationType;
            this.annotation = annotation;
            this.prefix = prefix;
        }

        public <T> void to(Class<T> configClass) {
            if (this.annotationType != null) {
                ConfigBinder.configBinder(this.binder).bindConfig(configClass, this.annotationType, this.prefix);
            } else if (this.annotation != null) {
                ConfigBinder.configBinder(this.binder).bindConfig(configClass, this.annotation, this.prefix);
            } else {
                ConfigBinder.configBinder(this.binder).bindConfig(configClass, this.prefix);
            }
        }
    }

    public static class PrefixBindingBuilder
    extends ConfigBindingBuilder {
        public PrefixBindingBuilder(Binder binder, Class<? extends Annotation> annotationType, Annotation annotation) {
            super(binder, annotationType, annotation, null);
        }

        public ConfigBindingBuilder prefixedWith(String prefix) {
            return new ConfigBindingBuilder(this.binder, this.annotationType, this.annotation, prefix);
        }
    }

    public static class AnnotatedBindingBuilder
    extends PrefixBindingBuilder {
        public AnnotatedBindingBuilder(Binder binder) {
            super(binder, null, null);
        }

        public PrefixBindingBuilder annotatedWith(Class<? extends Annotation> annotationType) {
            return new PrefixBindingBuilder(this.binder, annotationType, null);
        }

        public PrefixBindingBuilder annotatedWith(Annotation annotation) {
            return new PrefixBindingBuilder(this.binder, null, annotation);
        }
    }
}

