/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;

public class ServletAsyncContextDelegateProvider
implements AsyncContextDelegateProvider {
    public AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
        return new ServletAsyncContextDelegate(request, response);
    }

    private static class ServletAsyncContextDelegate
    implements AsyncContextDelegate {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AtomicReference<AsyncContext> asyncContext = new AtomicReference();

        private ServletAsyncContextDelegate(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public void suspend() throws IllegalStateException {
            AsyncContext asyncContext = this.request.startAsync((ServletRequest)this.request, (ServletResponse)this.response);
            asyncContext.setTimeout(-1L);
            this.asyncContext.set(asyncContext);
        }

        public void complete() {
            AsyncContext asyncContext = this.asyncContext.getAndSet(null);
            if (asyncContext == null) {
                return;
            }
            asyncContext.complete();
        }
    }
}

