/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.json.JsonKeySerde;

public class JsonBinder {
    private final MapBinder<Class<?>, JsonSerializer<?>> keySerializerMapBinder;
    private final MapBinder<Class<?>, KeyDeserializer> keyDeserializerMapBinder;
    private final MapBinder<Class<?>, JsonSerializer<?>> serializerMapBinder;
    private final MapBinder<Class<?>, JsonDeserializer<?>> deserializerMapBinder;
    private final Multibinder<Module> moduleBinder;

    public static JsonBinder jsonBinder(Binder binder) {
        return new JsonBinder(binder);
    }

    private JsonBinder(Binder binder) {
        this.keySerializerMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<JsonSerializer<?>>(){}, JsonKeySerde.class);
        this.keyDeserializerMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<KeyDeserializer>(){}, JsonKeySerde.class);
        this.serializerMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<JsonSerializer<?>>(){});
        this.deserializerMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<JsonDeserializer<?>>(){});
        this.moduleBinder = Multibinder.newSetBinder((Binder)binder, Module.class);
    }

    public LinkedBindingBuilder<JsonSerializer<?>> addKeySerializerBinding(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return this.keySerializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<KeyDeserializer> addKeyDeserializerBinding(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return this.keyDeserializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<JsonSerializer<?>> addSerializerBinding(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return this.serializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<JsonDeserializer<?>> addDeserializerBinding(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return this.deserializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<Module> addModuleBinding() {
        return this.moduleBinder.addBinding();
    }

    public <T> void bindSerializer(JsonSerializer<T> jsonSerializer) {
        Preconditions.checkNotNull(jsonSerializer, (Object)"jsonSerializer is null");
        Class type = jsonSerializer.handledType();
        Preconditions.checkNotNull((Object)type, (Object)"jsonSerializer.handledType is null");
        Preconditions.checkArgument((type == Object.class ? 1 : 0) != 0, (Object)"jsonSerializer.handledType can not be Object.class");
        this.serializerMapBinder.addBinding((Object)type).toInstance(jsonSerializer);
    }
}

