/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.collect.Lists;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.NullEventClient;
import io.airlift.sample.Person;
import io.airlift.sample.PersonRepresentation;
import io.airlift.sample.PersonStore;
import io.airlift.sample.PersonsResource;
import io.airlift.sample.StoreConfig;
import io.airlift.testing.Assertions;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestPersonsResource {
    private PersonsResource resource;
    private PersonStore store;

    @BeforeMethod
    public void setup() {
        this.store = new PersonStore(new StoreConfig(), (EventClient)new NullEventClient());
        this.resource = new PersonsResource(this.store);
    }

    @Test
    public void testEmpty() {
        Response response = this.resource.listAll();
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
        Assertions.assertInstanceOf((Object)response.getEntity(), Collection.class);
        Assert.assertEquals((Collection)((Collection)response.getEntity()), (Collection)Lists.newArrayList());
    }

    @Test
    public void testListAll() {
        this.store.put("foo", new Person("foo@example.com", "Mr Foo"));
        this.store.put("bar", new Person("bar@example.com", "Mr Bar"));
        Response response = this.resource.listAll();
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
        Assertions.assertInstanceOf((Object)response.getEntity(), Collection.class);
        Assert.assertEquals((Collection)((Collection)response.getEntity()), (Collection)Lists.newArrayList((Object[])new PersonRepresentation[]{new PersonRepresentation("foo@example.com", "Mr Foo", null), new PersonRepresentation("bar@example.com", "Mr Bar", null)}));
    }
}

