/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.google.common.net.InetAddresses;
import com.google.inject.Inject;
import io.airlift.jmx.JmxConfig;
import io.airlift.jmx.NetUtils;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class JmxAgent {
    private final String host;
    private final int registryPort;
    private final int serverPort;
    private final JMXConnectorServer connectorServer;
    private static final Logger log = Logger.get(JmxAgent.class);
    private final JMXServiceURL url;

    @Inject
    public JmxAgent(MBeanServer server, JmxConfig config, NodeInfo nodeInfo) throws IOException {
        this.host = config.getHostname() == null ? InetAddresses.toUriString((InetAddress)nodeInfo.getInternalIp()) : config.getHostname();
        this.registryPort = config.getRmiRegistryPort() == null ? NetUtils.findUnusedPort() : config.getRmiRegistryPort();
        this.serverPort = config.getRmiServerPort() == null ? NetUtils.findUnusedPort() : config.getRmiServerPort();
        try {
            this.url = new JMXServiceURL(String.format("service:jmx:rmi://%s:%d/jndi/rmi://%s:%d/jmxrmi", this.host, this.serverPort, this.host, this.registryPort));
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.url, Collections.emptyMap(), server);
    }

    public JMXServiceURL getURL() {
        return this.url;
    }

    @PostConstruct
    public void start() throws IOException {
        System.setProperty("java.rmi.server.randomIDs", "true");
        System.setProperty("java.rmi.server.hostname", this.host);
        LocateRegistry.createRegistry(this.registryPort);
        this.connectorServer.start();
        log.info("JMX Agent listening on %s:%s", new Object[]{this.host, this.registryPort});
    }

    @PreDestroy
    public void stop() throws IOException {
        this.connectorServer.stop();
    }
}

