/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.http.client.AbstractHttpClientModule;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.CompositeQualifier;
import io.airlift.http.client.CompositeQualifierImpl;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.netty.NettyAsyncHttpClient;
import io.airlift.http.client.netty.NettyAsyncHttpClientConfig;
import io.airlift.http.client.netty.NettyIoPool;
import io.airlift.http.client.netty.NettyIoPoolConfig;
import io.airlift.log.Logger;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.weakref.jmx.guice.ExportBinder;

@Beta
public class AsyncHttpClientModule
extends AbstractHttpClientModule {
    private static final Logger log = Logger.get(AsyncHttpClientModule.class);

    protected AsyncHttpClientModule(String name, Class<? extends Annotation> annotation) {
        super(name, annotation);
    }

    @Override
    public Annotation getFilterQualifier() {
        return AsyncHttpClientModule.filterQualifier(this.annotation);
    }

    void withPrivateIoThreadPool() {
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith(this.annotation).prefixedWith(this.name).to(NettyIoPoolConfig.class);
        this.binder.bind(NettyIoPool.class).annotatedWith(this.annotation).toProvider((Provider)new NettyIoPoolProvider(this.name, this.annotation)).in(Scopes.SINGLETON);
    }

    @Override
    public void configure() {
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith(this.annotation).prefixedWith(this.name).to(HttpClientConfig.class);
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith(this.annotation).prefixedWith(this.name).to(NettyAsyncHttpClientConfig.class);
        ConfigurationModule.bindConfig((Binder)this.binder).to(NettyIoPoolConfig.class);
        this.binder.bind(NettyIoPool.class).toProvider(SharedNettyIoPoolProvider.class).in(Scopes.SINGLETON);
        this.binder.bind(AsyncHttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.name, this.annotation)).in(Scopes.SINGLETON);
        this.binder.bind(HttpClient.class).annotatedWith(this.annotation).to(Key.get(AsyncHttpClient.class, (Class)this.annotation));
        Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, (Annotation)AsyncHttpClientModule.filterQualifier(this.annotation));
        ExportBinder.newExporter((Binder)this.binder).export(AsyncHttpClient.class).annotatedWith(this.annotation).withGeneratedName();
    }

    @Override
    public void addAlias(Class<? extends Annotation> alias) {
        this.binder.bind(AsyncHttpClient.class).annotatedWith(alias).to(Key.get(AsyncHttpClient.class, (Class)this.annotation));
        this.binder.bind(HttpClient.class).annotatedWith(alias).to(Key.get(AsyncHttpClient.class, (Class)this.annotation));
    }

    private static <T> Key<T> keyFromNullable(Class<T> type, Class<? extends Annotation> annotation) {
        return annotation != null ? Key.get(type, annotation) : Key.get(type);
    }

    private static Key<Set<HttpRequestFilter>> filterKey(Class<? extends Annotation> annotation) {
        return Key.get((TypeLiteral)new TypeLiteral<Set<HttpRequestFilter>>(){}, (Annotation)AsyncHttpClientModule.filterQualifier(annotation));
    }

    private static CompositeQualifier filterQualifier(Class<? extends Annotation> annotation) {
        return CompositeQualifierImpl.compositeQualifier(annotation, AsyncHttpClient.class);
    }

    private static class NettyIoPoolProvider
    implements Provider<NettyIoPool> {
        private final List<NettyIoPool> pools = new ArrayList<NettyIoPool>();
        private final String name;
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private NettyIoPoolProvider(String name, Class<? extends Annotation> annotation) {
            this.name = name;
            this.annotation = annotation;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        @PreDestroy
        public void destroy() {
            for (NettyIoPool pool : this.pools) {
                pool.close();
            }
        }

        public NettyIoPool get() {
            NettyIoPoolConfig config = (NettyIoPoolConfig)this.injector.getInstance(AsyncHttpClientModule.keyFromNullable(NettyIoPoolConfig.class, this.annotation));
            NettyIoPool pool = new NettyIoPool(this.name, config);
            this.pools.add(pool);
            return pool;
        }
    }

    private static class SharedNettyIoPoolProvider
    extends NettyIoPoolProvider {
        private SharedNettyIoPoolProvider() {
            super("shared", null);
        }
    }

    private static class HttpClientProvider
    implements Provider<AsyncHttpClient> {
        private final List<NettyAsyncHttpClient> clients = new ArrayList<NettyAsyncHttpClient>();
        private final String name;
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private HttpClientProvider(String name, Class<? extends Annotation> annotation) {
            this.name = name;
            this.annotation = annotation;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        @PreDestroy
        public void destroy() {
            for (NettyAsyncHttpClient client : this.clients) {
                client.close();
            }
        }

        public AsyncHttpClient get() {
            NettyIoPool ioPool;
            HttpClientConfig config = (HttpClientConfig)this.injector.getInstance(Key.get(HttpClientConfig.class, this.annotation));
            NettyAsyncHttpClientConfig asyncConfig = (NettyAsyncHttpClientConfig)this.injector.getInstance(Key.get(NettyAsyncHttpClientConfig.class, this.annotation));
            Set filters = (Set)this.injector.getInstance(AsyncHttpClientModule.filterKey(this.annotation));
            if (this.injector.getExistingBinding(Key.get(NettyIoPool.class, this.annotation)) != null) {
                ioPool = (NettyIoPool)this.injector.getInstance(Key.get(NettyIoPool.class, this.annotation));
                log.debug("HttpClient %s uses private IO thread pool", new Object[]{this.name});
            } else {
                log.debug("HttpClient %s uses shared IO thread pool", new Object[]{this.name});
                ioPool = (NettyIoPool)this.injector.getInstance(NettyIoPool.class);
            }
            NettyAsyncHttpClient client = new NettyAsyncHttpClient(this.name, ioPool, config, asyncConfig, filters);
            this.clients.add(client);
            return client;
        }
    }
}

