/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.http.client.AbstractHttpClientModule;
import io.airlift.http.client.AsyncHttpClientModule;
import io.airlift.http.client.HttpClientModule;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.TraceTokenRequestFilter;
import java.lang.annotation.Annotation;
import java.util.Collection;

@Beta
public class HttpClientBinder {
    private final Binder binder;

    private HttpClientBinder(Binder binder) {
        this.binder = (Binder)Preconditions.checkNotNull((Object)binder, (Object)"binder is null");
    }

    public static HttpClientBinder httpClientBinder(Binder binder) {
        return new HttpClientBinder(binder);
    }

    public HttpClientBindingBuilder bindHttpClient(String name, Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(annotation, (Object)"annotation is null");
        return this.createBindingBuilder(new HttpClientModule(name, annotation));
    }

    public HttpClientAsyncBindingBuilder bindAsyncHttpClient(String name, Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(annotation, (Object)"annotation is null");
        return this.createAsyncBindingBuilder(new AsyncHttpClientModule(name, annotation));
    }

    private HttpClientBindingBuilder createBindingBuilder(AbstractHttpClientModule module) {
        this.binder.install((Module)module);
        return new HttpClientBindingBuilder(module, Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, (Annotation)module.getFilterQualifier()));
    }

    private HttpClientAsyncBindingBuilder createAsyncBindingBuilder(AsyncHttpClientModule module) {
        this.binder.install((Module)module);
        return new HttpClientAsyncBindingBuilder(module, Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, (Annotation)module.getFilterQualifier()));
    }

    protected static abstract class AbstractHttpClientBindingBuilder<T extends AbstractHttpClientBindingBuilder<T>> {
        protected final AbstractHttpClientModule module;
        private final Multibinder<HttpRequestFilter> multibinder;

        private AbstractHttpClientBindingBuilder(AbstractHttpClientModule module, Multibinder<HttpRequestFilter> multibinder) {
            this.module = module;
            this.multibinder = multibinder;
        }

        public T withAlias(Class<? extends Annotation> alias) {
            this.module.addAlias(alias);
            return (T)this;
        }

        public T withAliases(Collection<Class<? extends Annotation>> aliases) {
            for (Class<? extends Annotation> annotation : aliases) {
                this.module.addAlias(annotation);
            }
            return (T)this;
        }

        public LinkedBindingBuilder<HttpRequestFilter> addFilterBinding() {
            return this.multibinder.addBinding();
        }

        public T withFilter(Class<? extends HttpRequestFilter> filterClass) {
            this.multibinder.addBinding().to(filterClass);
            return (T)this;
        }

        public T withTracing() {
            return this.withFilter(TraceTokenRequestFilter.class);
        }
    }

    public static class HttpClientAsyncBindingBuilder
    extends AbstractHttpClientBindingBuilder<HttpClientAsyncBindingBuilder> {
        private final AsyncHttpClientModule module;

        private HttpClientAsyncBindingBuilder(AsyncHttpClientModule module, Multibinder<HttpRequestFilter> multibinder) {
            super(module, multibinder);
            this.module = module;
        }

        public HttpClientAsyncBindingBuilder withPrivateIoThreadPool() {
            this.module.withPrivateIoThreadPool();
            return this;
        }
    }

    public static class HttpClientBindingBuilder
    extends AbstractHttpClientBindingBuilder<HttpClientBindingBuilder> {
        private HttpClientBindingBuilder(AbstractHttpClientModule module, Multibinder<HttpRequestFilter> multibinder) {
            super(module, multibinder);
        }
    }
}

