/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.google.common.primitives.Ints;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.util.Set;

public class JsonResponseHandler<T>
implements ResponseHandler<T, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final JsonCodec<T> jsonCodec;
    private final Set<Integer> successfulResponseCodes;

    public static <T> JsonResponseHandler<T> createJsonResponseHandler(JsonCodec<T> jsonCodec) {
        return new JsonResponseHandler<T>(jsonCodec);
    }

    public static <T> JsonResponseHandler<T> createJsonResponseHandler(JsonCodec<T> jsonCodec, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        return new JsonResponseHandler<T>(jsonCodec, firstSuccessfulResponseCode, otherSuccessfulResponseCodes);
    }

    private JsonResponseHandler(JsonCodec<T> jsonCodec) {
        this(jsonCodec, 200, 201, 202, 203, 204, 205, 206);
    }

    private JsonResponseHandler(JsonCodec<T> jsonCodec, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        this.jsonCodec = jsonCodec;
        this.successfulResponseCodes = ImmutableSet.builder().add((Object)firstSuccessfulResponseCode).addAll((Iterable)Ints.asList((int[])otherSuccessfulResponseCodes)).build();
    }

    @Override
    public RuntimeException handleException(Request request, Exception exception) {
        if (exception instanceof ConnectException) {
            return new RuntimeException("Server refused connection: " + request.getUri().toASCIIString(), exception);
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }

    @Override
    public T handle(Request request, Response response) {
        if (!this.successfulResponseCodes.contains(response.getStatusCode())) {
            throw new UnexpectedResponseException(String.format("Expected response code to be %s, but was %d: %s", this.successfulResponseCodes, response.getStatusCode(), response.getStatusMessage()), request, response);
        }
        String contentType = response.getHeader("Content-Type");
        if (contentType == null) {
            throw new UnexpectedResponseException("Content-Type is not set for response", request, response);
        }
        if (!MediaType.parse((String)contentType).is(MEDIA_TYPE_JSON)) {
            throw new UnexpectedResponseException("Expected application/json response from server but got " + contentType, request, response);
        }
        try {
            String json = CharStreams.toString((Readable)new InputStreamReader(response.getInputStream(), Charsets.UTF_8));
            Object value = this.jsonCodec.fromJson(json);
            return (T)value;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading response from server");
        }
    }
}

