/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import io.airlift.stats.CounterStat;
import io.airlift.stats.MeterStat;
import io.airlift.stats.TimedStat;
import io.airlift.units.Duration;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Beta
public class RequestStats {
    private final CounterStat request = new CounterStat();
    private final TimedStat requestTime = new TimedStat();
    private final TimedStat responseTime = new TimedStat();
    private final MeterStat readBytes = new MeterStat();
    private final MeterStat writtenBytes = new MeterStat();

    @Inject
    public RequestStats() {
    }

    public void record(String method, int responseCode, long requestSizeInBytes, long responseSizeInBytes, Duration requestProcessingTime, Duration responseProcessingTime) {
        this.request.update(1L);
        if (requestProcessingTime != null) {
            this.requestTime.addValue(requestProcessingTime);
        }
        if (requestProcessingTime != null) {
            this.responseTime.addValue(responseProcessingTime);
        }
        this.readBytes.update(responseSizeInBytes);
        this.writtenBytes.update(requestSizeInBytes);
    }

    @Managed
    @Flatten
    public CounterStat getRequest() {
        return this.request;
    }

    @Managed
    @Nested
    public TimedStat getRequestTime() {
        return this.requestTime;
    }

    @Managed
    @Nested
    public TimedStat getResponseTime() {
        return this.responseTime;
    }

    @Managed
    @Nested
    public MeterStat getReadBytes() {
        return this.readBytes;
    }

    @Managed
    @Nested
    public MeterStat getWrittenBytes() {
        return this.writtenBytes;
    }
}

