/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import java.net.ConnectException;
import java.util.List;

public class StatusResponseHandler
implements ResponseHandler<StatusResponse, RuntimeException> {
    private static final StatusResponseHandler statusResponseHandler = new StatusResponseHandler();

    public static StatusResponseHandler createStatusResponseHandler() {
        return statusResponseHandler;
    }

    private StatusResponseHandler() {
    }

    @Override
    public RuntimeException handleException(Request request, Exception exception) {
        if (exception instanceof ConnectException) {
            return new RuntimeException("Server refused connection: " + request.getUri().toASCIIString(), exception);
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }

    @Override
    public StatusResponse handle(Request request, Response response) {
        return new StatusResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
    }

    public static class StatusResponse {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<String, String> headers;

        public StatusResponse(int statusCode, String statusMessage, ListMultimap<String, String> headers) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)name);
            if (values.isEmpty()) {
                return null;
            }
            return (String)values.get(0);
        }

        public ListMultimap<String, String> getHeaders() {
            return this.headers;
        }
    }
}

