/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.http.client.netty.CanceledRequestException;
import io.airlift.http.client.netty.PermitQueue;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.ssl.SslHandler;

@ThreadSafe
public class NettyConnectionPool
implements Closeable {
    private final ChannelGroup openChannels = new DefaultChannelGroup("http-client");
    private final ClientBootstrap bootstrap;
    private final Executor executor;
    private final PermitQueue connectionPermits;
    @GuardedBy(value="this")
    private final LinkedListMultimap<PoolKey, Channel> channelCache = LinkedListMultimap.create();
    private final int maxConnections;
    private final AtomicInteger checkedOutConnections = new AtomicInteger();
    private final boolean enablePooling;

    public NettyConnectionPool(ClientBootstrap bootstrap, int maxConnections, Executor executorService, boolean enablePooling) {
        this.bootstrap = bootstrap;
        this.maxConnections = maxConnections;
        this.connectionPermits = new PermitQueue(this.maxConnections);
        this.executor = executorService;
        this.enablePooling = enablePooling;
    }

    @Override
    public void close() {
        this.openChannels.close();
    }

    public void execute(URI uri, final ConnectionCallback connectionCallback) {
        final boolean isSsl = "https".equalsIgnoreCase(uri.getScheme());
        int port = uri.getPort();
        if (port < 0) {
            port = isSsl ? 443 : 80;
        }
        final InetSocketAddress remoteAddress = new InetSocketAddress(uri.getHost(), port);
        if (this.enablePooling) {
            ListenableFuture<?> acquireFuture = this.connectionPermits.acquire();
            acquireFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    NettyConnectionPool.this.connectionPermitAcquired(isSsl, remoteAddress, connectionCallback);
                }
            }, this.executor);
        } else {
            this.openConnecton(isSsl, remoteAddress, connectionCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionPermitAcquired(boolean isSsl, InetSocketAddress remoteAddress, ConnectionCallback connectionCallback) {
        Preconditions.checkState((boolean)this.enablePooling, (Object)"Pooling is not enabled");
        Channel channel = null;
        NettyConnectionPool nettyConnectionPool = this;
        synchronized (nettyConnectionPool) {
            PoolKey key = new PoolKey(isSsl, remoteAddress);
            List channels = this.channelCache.get((Object)key);
            while (channel == null && !channels.isEmpty()) {
                channel = (Channel)channels.remove(channels.size() - 1);
                if (channel.isConnected()) continue;
                channel.close();
                channel = null;
            }
            if (channel == null) {
                int pooledConnectionCount = this.channelCache.size();
                int checkedOutConnectionCount = this.checkedOutConnections.get();
                int connectionsToDestroy = checkedOutConnectionCount + pooledConnectionCount + 1 - this.maxConnections;
                for (int i = 0; !channels.isEmpty() && i < connectionsToDestroy; ++i) {
                    Channel victim = (Channel)channels.remove(channels.size() - 1);
                    victim.close();
                }
            }
        }
        this.checkedOutConnections.incrementAndGet();
        if (channel == null) {
            this.openConnecton(isSsl, remoteAddress, connectionCallback);
        } else {
            try {
                connectionCallback.run(channel);
            }
            catch (Throwable e) {
                connectionCallback.onError(e);
            }
        }
    }

    private void openConnecton(boolean isSsl, InetSocketAddress remoteAddress, ConnectionCallback connectionCallback) {
        ChannelFuture future = this.bootstrap.connect((SocketAddress)remoteAddress);
        if (isSsl) {
            future.addListener((ChannelFutureListener)new SslConnectionListener(remoteAddress, connectionCallback, this.openChannels));
        } else {
            future.addListener((ChannelFutureListener)new CallbackConnectionListener(remoteAddress, connectionCallback, this.openChannels));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void returnConnection(Channel channel) {
        try {
            if (channel != null) {
                if (this.enablePooling && channel.isConnected()) {
                    boolean isSsl;
                    InetSocketAddress remoteAddress = (InetSocketAddress)channel.getRemoteAddress();
                    boolean bl = isSsl = channel.getPipeline().get(SslHandler.class) != null;
                    if (remoteAddress != null) {
                        PoolKey key = new PoolKey(isSsl, remoteAddress);
                        this.channelCache.put((Object)key, (Object)channel);
                        return;
                    }
                }
                channel.close();
            }
        }
        finally {
            this.checkedOutConnections.decrementAndGet();
            if (this.enablePooling) {
                this.connectionPermits.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyConnection(Channel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        finally {
            this.checkedOutConnections.decrementAndGet();
            if (this.enablePooling) {
                this.connectionPermits.release();
            }
        }
    }

    private static class PoolKey {
        private final boolean isSsl;
        private final HostAndPort hostAndPort;

        PoolKey(boolean isSsl, InetSocketAddress remoteAddress) {
            this.isSsl = isSsl;
            if (isSsl) {
                this.hostAndPort = HostAndPort.fromParts((String)remoteAddress.getHostString(), (int)remoteAddress.getPort());
            } else {
                String address = InetAddresses.toAddrString((InetAddress)remoteAddress.getAddress());
                this.hostAndPort = HostAndPort.fromParts((String)address, (int)remoteAddress.getPort());
            }
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.isSsl, this.hostAndPort});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PoolKey other = (PoolKey)obj;
            return Objects.equal((Object)this.isSsl, (Object)other.isSsl) && Objects.equal((Object)this.hostAndPort, (Object)other.hostAndPort);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("isSsl", this.isSsl).add("hostAndPort", (Object)this.hostAndPort).toString();
        }
    }

    private static class SslConnectionListener
    implements ChannelFutureListener {
        private final InetSocketAddress remoteAddress;
        private final ConnectionCallback connectionCallback;
        private final ChannelGroup openChannels;

        public SslConnectionListener(InetSocketAddress remoteAddress, ConnectionCallback connectionCallback, ChannelGroup openChannels) {
            this.remoteAddress = remoteAddress;
            this.connectionCallback = connectionCallback;
            this.openChannels = openChannels;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            CallbackConnectionListener callbackConnectionListener = new CallbackConnectionListener(this.remoteAddress, this.connectionCallback, this.openChannels);
            if (future.isSuccess()) {
                SSLParameters sslParameters = new SSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                SSLEngine sslEngine = SSLContext.getDefault().createSSLEngine(this.remoteAddress.getHostString(), this.remoteAddress.getPort());
                sslEngine.setSSLParameters(sslParameters);
                sslEngine.setUseClientMode(true);
                SslHandler sslHandler = new SslHandler(sslEngine);
                future.getChannel().getPipeline().addBefore("codec", "ssl", (ChannelHandler)sslHandler);
                ChannelFuture handshakeFuture = sslHandler.handshake();
                handshakeFuture.addListener((ChannelFutureListener)callbackConnectionListener);
            } else {
                callbackConnectionListener.operationComplete(future);
            }
        }
    }

    public static interface ConnectionCallback {
        public void run(Channel var1) throws Exception;

        public void onError(Throwable var1);
    }

    private static class CallbackConnectionListener
    implements ChannelFutureListener {
        private final InetSocketAddress remoteAddress;
        private final ConnectionCallback connectionCallback;
        private final ChannelGroup openChannels;

        private CallbackConnectionListener(InetSocketAddress remoteAddress, ConnectionCallback connectionCallback, ChannelGroup openChannels) {
            this.remoteAddress = remoteAddress;
            this.connectionCallback = connectionCallback;
            this.openChannels = openChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                Channel channel = future.getChannel();
                try {
                    this.openChannels.add((Object)channel);
                    this.connectionCallback.run(channel);
                }
                catch (Throwable e) {
                    try {
                        channel.close();
                    }
                    finally {
                        this.connectionCallback.onError(e);
                    }
                }
            } else if (future.isCancelled()) {
                this.connectionCallback.onError(new CanceledRequestException());
            } else {
                Throwable cause = future.getCause();
                String message = String.valueOf(this.remoteAddress);
                if (cause != null && cause.getMessage() != null) {
                    message = cause.getMessage() + " to " + this.remoteAddress;
                }
                SocketTimeoutException e = new SocketTimeoutException(message);
                e.initCause(cause);
                this.connectionCallback.onError(e);
            }
        }
    }
}

