/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.netty.NettyResponse;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class NettyResponseFuture<T, E extends Exception>
extends AbstractFuture<T>
implements AsyncHttpClient.AsyncHttpResponseFuture<T, E> {
    private final long requestStart = System.nanoTime();
    private final AtomicReference<NettyAsyncHttpState> state = new AtomicReference<NettyAsyncHttpState>(NettyAsyncHttpState.WAITING_FOR_CONNECTION);
    private final Request request;
    private final ResponseHandler<T, E> responseHandler;
    private final RequestStats stats;
    private static final Logger log = Logger.get(NettyResponseFuture.class);

    public NettyResponseFuture(Request request, ResponseHandler<T, E> responseHandler, RequestStats stats) {
        this.request = request;
        this.responseHandler = responseHandler;
        this.stats = stats;
    }

    @Override
    public String getState() {
        return this.state.get().toString();
    }

    protected void setState(NettyAsyncHttpState state) {
        this.state.set(state);
    }

    protected boolean setException(Throwable throwable) {
        if (this.state.get() == NettyAsyncHttpState.CANCELED) {
            return false;
        }
        if (throwable instanceof CancellationException) {
            this.state.set(NettyAsyncHttpState.CANCELED);
        } else {
            this.state.set(NettyAsyncHttpState.FAILED);
        }
        if (throwable == null) {
            throwable = new Throwable("Throwable is null");
            log.error(throwable, "Something is broken", new Object[0]);
        }
        Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable.getMessage(), throwable);
        try {
            E e = this.responseHandler.handleException(this.request, exception);
            if (e != null) {
                throwable = e;
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        return super.setException(throwable);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.state.set(NettyAsyncHttpState.CANCELED);
        return super.cancel(mayInterruptIfRunning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completed(HttpResponse httpResponse) {
        if (this.state.get() == NettyAsyncHttpState.CANCELED) {
            return;
        }
        long responseStart = System.nanoTime();
        this.state.set(NettyAsyncHttpState.PROCESSING_RESPONSE);
        NettyResponse response = null;
        try {
            response = new NettyResponse(httpResponse);
            T value = this.responseHandler.handle(this.request, response);
            this.set(value);
            this.state.set(NettyAsyncHttpState.DONE);
        }
        catch (Exception e) {
            this.setException(new ExceptionFromResponseHandler(e));
        }
        finally {
            Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
            Duration requestProcessingTime = new Duration((double)(responseStart - this.requestStart), TimeUnit.NANOSECONDS);
            if (response != null) {
                this.stats.record(this.request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
            }
        }
    }

    public T checkedGet() throws E {
        try {
            return (T)this.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            throw this.mapException(e);
        }
    }

    public T checkedGet(long timeout, TimeUnit unit) throws TimeoutException, E {
        try {
            return (T)this.get(timeout, unit);
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            throw this.mapException(e);
        }
    }

    private E mapException(Exception e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (e instanceof ExecutionException) {
            Throwable cause = e.getCause();
            if (cause instanceof ExceptionFromResponseHandler) {
                try {
                    return (E)((Exception)cause.getCause());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (cause instanceof Exception) {
                e = (Exception)cause;
            }
        }
        return this.responseHandler.handleException(this.request, e);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("requestStart", this.requestStart).add("state", this.state).add("request", (Object)this.request).toString();
    }

    private static class ExceptionFromResponseHandler
    extends Exception {
        private ExceptionFromResponseHandler(Exception cause) {
            super((Throwable)Preconditions.checkNotNull((Object)cause, (Object)"cause is null"));
        }
    }

    public static enum NettyAsyncHttpState {
        WAITING_FOR_CONNECTION,
        SENDING_REQUEST,
        WAITING_FOR_RESPONSE,
        PROCESSING_RESPONSE,
        DONE,
        FAILED,
        CANCELED;

    }
}

