/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs.testing;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class MockUriInfo
implements UriInfo {
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/');
    private static final Splitter QUERY_STRING_SPLITTER = Splitter.on((char)'&').trimResults().omitEmptyStrings();
    private static final Splitter QUERY_PARAM_SPLITTER = Splitter.on((char)'=');
    private static final Joiner QUERY_PARAM_VALUE_JOINER = Joiner.on((String)"");
    private final URI requestUri;
    private final URI baseUri;

    public static UriInfo from(String requestUri) {
        return new MockUriInfo(URI.create(requestUri));
    }

    public static UriInfo from(URI requestUri) {
        return new MockUriInfo(requestUri);
    }

    public MockUriInfo(URI requestUri) {
        this(requestUri, requestUri.resolve("/"));
    }

    public MockUriInfo(URI requestUri, URI baseUri) {
        this.requestUri = requestUri;
        this.baseUri = baseUri;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    public URI getAbsolutePath() {
        return UriBuilder.fromUri((URI)this.requestUri).replaceQuery("").fragment("").build(new Object[0]);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        return this.getRequestUri().getRawPath().substring(this.getBaseUri().getRawPath().length());
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String path : PATH_SPLITTER.split((CharSequence)this.getPath(decode))) {
            builder.add((Object)new ImmutablePathSegment(path));
        }
        return builder.build();
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return MockUriInfo.decodeQuery(this.getRequestUri().getRawQuery(), decode);
    }

    public static MultivaluedMap<String, String> decodeQuery(String query, boolean decode) {
        if (query == null) {
            return GuavaMultivaluedMap.emptyMultivaluedMap();
        }
        ArrayListMultimap map = ArrayListMultimap.create();
        for (String param : QUERY_STRING_SPLITTER.split((CharSequence)query)) {
            ImmutableList pair = ImmutableList.copyOf((Iterable)QUERY_PARAM_SPLITTER.split((CharSequence)param));
            if (pair.isEmpty()) continue;
            String key = MockUriInfo.urlDecode((String)pair.get(0));
            String value = null;
            if (pair.size() != 1) {
                value = QUERY_PARAM_VALUE_JOINER.join(pair.subList(1, pair.size()));
                if (decode) {
                    value = MockUriInfo.urlDecode(value);
                }
            }
            map.put((Object)key, value);
        }
        return GuavaMultivaluedMap.createGuavaMultivaluedMap(map);
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        throw new UnsupportedOperationException();
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getMatchedResources() {
        throw new UnsupportedOperationException();
    }

    private static class ImmutablePathSegment
    implements PathSegment {
        private final String path;

        public ImmutablePathSegment(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return GuavaMultivaluedMap.emptyMultivaluedMap();
        }
    }

    static class GuavaMultivaluedMap<K, V>
    extends ForwardingMap<K, List<V>>
    implements MultivaluedMap<K, V> {
        private final ListMultimap<K, V> multimap;

        static <K, V> GuavaMultivaluedMap<K, V> emptyMultivaluedMap() {
            return new GuavaMultivaluedMap<K, V>(ImmutableListMultimap.of());
        }

        static <K, V> GuavaMultivaluedMap<K, V> createGuavaMultivaluedMap(ListMultimap<K, V> multimap) {
            return new GuavaMultivaluedMap<K, V>(multimap);
        }

        private GuavaMultivaluedMap(ListMultimap<K, V> multimap) {
            this.multimap = multimap;
        }

        public void putSingle(K key, V value) {
            this.multimap.removeAll(key);
            this.multimap.put(key, value);
        }

        protected Map<K, List<V>> delegate() {
            return this.multimap.asMap();
        }

        public void add(K key, V value) {
            this.multimap.put(key, value);
        }

        public V getFirst(K key) {
            return (V)Iterables.getFirst((Iterable)this.multimap.get(key), null);
        }
    }
}

