/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import io.airlift.event.client.EventClient;
import io.airlift.http.server.CurrentTimeMillisProvider;
import io.airlift.http.server.HttpRequestEvent;
import io.airlift.http.server.SystemCurrentTimeMillisProvider;
import io.airlift.tracetoken.TraceTokenManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.component.LifeCycle;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

class DelimitedRequestLog
implements RequestLog {
    private final RolloverFileOutputStream out;
    private final Writer writer;
    private final DateTimeFormatter isoFormatter;
    private final TraceTokenManager traceTokenManager;
    private final EventClient eventClient;
    private final CurrentTimeMillisProvider currentTimeMillisProvider;

    public DelimitedRequestLog(String filename, int retainDays, TraceTokenManager traceTokenManager, EventClient eventClient) throws IOException {
        this(filename, retainDays, traceTokenManager, eventClient, new SystemCurrentTimeMillisProvider());
    }

    public DelimitedRequestLog(String filename, int retainDays, TraceTokenManager traceTokenManager, EventClient eventClient, CurrentTimeMillisProvider currentTimeMillisProvider) throws IOException {
        this.traceTokenManager = traceTokenManager;
        this.eventClient = eventClient;
        this.currentTimeMillisProvider = currentTimeMillisProvider;
        this.out = new RolloverFileOutputStream(filename, true, retainDays);
        this.writer = new OutputStreamWriter((OutputStream)this.out);
        this.isoFormatter = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateHourMinuteSecondFraction()).appendTimeZoneOffset("Z", true, 2, 2).toFormatter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Request request, Response response) {
        long currentTime = this.currentTimeMillisProvider.getCurrentTimeMillis();
        HttpRequestEvent event = HttpRequestEvent.createHttpRequestEvent(request, response, this.traceTokenManager, currentTime);
        StringBuilder builder = new StringBuilder();
        builder.append(this.isoFormatter.print((ReadableInstant)event.getTimeStamp())).append('\t').append(event.getClientAddress()).append('\t').append(event.getMethod()).append('\t').append(request.getUri()).append('\t').append(event.getUser()).append('\t').append(event.getAgent()).append('\t').append(event.getResponseCode()).append('\t').append(event.getRequestSize()).append('\t').append(event.getResponseSize()).append('\t').append(event.getTimeToLastByte()).append('\t').append(event.getTraceToken()).append('\n');
        String line = builder.toString();
        Writer writer = this.writer;
        synchronized (writer) {
            try {
                this.writer.write(line);
                this.writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.eventClient.post((Object[])new HttpRequestEvent[]{event});
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.out.close();
    }

    public boolean isRunning() {
        return true;
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isStopped() {
        return false;
    }

    public boolean isFailed() {
        return false;
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }
}

