/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import io.airlift.stats.CounterStat;
import io.airlift.stats.MeterStat;
import io.airlift.stats.TimedStat;
import io.airlift.units.Duration;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class RequestStats {
    private final CounterStat request = new CounterStat();
    private final TimedStat requestTime = new TimedStat();
    private final MeterStat readBytes = new MeterStat();
    private final MeterStat writtenBytes = new MeterStat();

    @Inject
    public RequestStats() {
    }

    public void record(String method, int responseCode, long requestSizeInBytes, long responseSizeInBytes, Duration schedulingDelay, Duration requestProcessingTime) {
        this.request.update(1L);
        this.requestTime.addValue(requestProcessingTime);
        this.readBytes.update(requestSizeInBytes);
        this.writtenBytes.update(responseSizeInBytes);
    }

    @Managed
    @Flatten
    public CounterStat getRequest() {
        return this.request;
    }

    @Managed
    @Nested
    public TimedStat getRequestTime() {
        return this.requestTime;
    }

    @Managed
    @Nested
    public MeterStat getReadBytes() {
        return this.readBytes;
    }

    @Managed
    @Nested
    public MeterStat getWrittenBytes() {
        return this.writtenBytes;
    }
}

