/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import io.airlift.json.JsonCodec;
import io.airlift.json.ObjectMapperProvider;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JsonCodecFactory {
    private final Provider<ObjectMapper> objectMapperProvider;
    private final boolean prettyPrint;

    public JsonCodecFactory() {
        this(new ObjectMapperProvider());
    }

    @Inject
    public JsonCodecFactory(Provider<ObjectMapper> objectMapperProvider) {
        this(objectMapperProvider, false);
    }

    public JsonCodecFactory(Provider<ObjectMapper> objectMapperProvider, boolean prettyPrint) {
        this.objectMapperProvider = objectMapperProvider;
        this.prettyPrint = prettyPrint;
    }

    public JsonCodecFactory prettyPrint() {
        return new JsonCodecFactory(this.objectMapperProvider, true);
    }

    public <T> JsonCodec<T> jsonCodec(Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new JsonCodec(this.createObjectMapper(), type);
    }

    public <T> JsonCodec<T> jsonCodec(Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        return new JsonCodec(this.createObjectMapper(), type);
    }

    public <T> JsonCodec<T> jsonCodec(TypeLiteral<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new JsonCodec(this.createObjectMapper(), type.getType());
    }

    public <T> JsonCodec<List<T>> listJsonCodec(Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{type});
        return new JsonCodec<List<T>>(this.createObjectMapper(), (Type)listType);
    }

    public <T> JsonCodec<List<T>> listJsonCodec(JsonCodec<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{type.getType()});
        return new JsonCodec<List<T>>(this.createObjectMapper(), (Type)listType);
    }

    public <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, Class<V> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, Map.class, new Type[]{keyType, valueType});
        return new JsonCodec<Map<K, V>>(this.createObjectMapper(), (Type)mapType);
    }

    public <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, JsonCodec<V> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, Map.class, new Type[]{keyType, valueType.getType()});
        return new JsonCodec<Map<K, V>>(this.createObjectMapper(), (Type)mapType);
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = null;
        RuntimeException lastException = null;
        for (int i = 0; objectMapper == null && i < 10; ++i) {
            try {
                objectMapper = (ObjectMapper)this.objectMapperProvider.get();
                continue;
            }
            catch (RuntimeException e) {
                lastException = e;
            }
        }
        if (objectMapper == null) {
            throw lastException;
        }
        if (this.prettyPrint) {
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        } else {
            objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        }
        return objectMapper;
    }
}

