/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import io.airlift.discovery.client.HttpServiceSelector;
import io.airlift.discovery.client.ServiceType;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.EventSubmissionFailedException;
import io.airlift.event.client.ForEventClient;
import io.airlift.event.client.JsonEventWriter;
import io.airlift.event.client.ServiceUnavailableException;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class HttpEventClient
implements EventClient {
    private static final Logger log = Logger.get(HttpEventClient.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final HttpServiceSelector serviceSelector;
    private final JsonEventWriter eventWriter;
    private final AsyncHttpClient httpClient;
    private final NodeInfo nodeInfo;

    @Inject
    public HttpEventClient(@ServiceType(value="collector") HttpServiceSelector serviceSelector, JsonEventWriter eventWriter, NodeInfo nodeInfo, @ForEventClient AsyncHttpClient httpClient) {
        this.serviceSelector = (HttpServiceSelector)Preconditions.checkNotNull((Object)serviceSelector, (Object)"serviceSelector is null");
        this.eventWriter = (JsonEventWriter)Preconditions.checkNotNull((Object)eventWriter, (Object)"eventWriter is null");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.httpClient = (AsyncHttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
    }

    @Flatten
    @Managed
    public RequestStats getStats() {
        return this.httpClient.getStats();
    }

    @Override
    @SafeVarargs
    public final <T> CheckedFuture<Void, RuntimeException> post(T ... event) throws IllegalArgumentException {
        Preconditions.checkNotNull(event, (Object)"event is null");
        return this.post((Iterable<T>)Arrays.asList(event));
    }

    @Override
    public <T> CheckedFuture<Void, RuntimeException> post(final Iterable<T> events) throws IllegalArgumentException {
        Preconditions.checkNotNull(events, (Object)"eventsSupplier is null");
        return this.post(new EventClient.EventGenerator<T>(){

            @Override
            public void generate(EventClient.EventPoster<T> eventPoster) throws IOException {
                for (Object event : events) {
                    eventPoster.post(event);
                }
            }
        });
    }

    @Override
    public <T> CheckedFuture<Void, RuntimeException> post(EventClient.EventGenerator<T> eventGenerator) {
        Preconditions.checkNotNull(eventGenerator, (Object)"eventGenerator is null");
        List uris = this.serviceSelector.selectHttpService();
        if (uris.isEmpty()) {
            return Futures.immediateFailedCheckedFuture((Exception)new ServiceUnavailableException(this.serviceSelector.getType(), this.serviceSelector.getPool()));
        }
        Request request = Request.Builder.preparePost().setUri(((URI)uris.get(0)).resolve("/v2/event")).setHeader("User-Agent", this.nodeInfo.getNodeId()).setHeader("Content-Type", MEDIA_TYPE_JSON.toString()).setBodyGenerator(new JsonEntityWriter<T>(this.eventWriter, eventGenerator)).build();
        return this.httpClient.executeAsync(request, (ResponseHandler)new EventResponseHandler(this.serviceSelector.getType(), this.serviceSelector.getPool()));
    }

    private static class EventResponseHandler
    implements ResponseHandler<Void, RuntimeException> {
        private final String type;
        private final String pool;

        public EventResponseHandler(String type, String pool) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type is null");
            this.pool = (String)Preconditions.checkNotNull((Object)pool, (Object)"pool is null");
        }

        public EventSubmissionFailedException handleException(Request request, Exception exception) {
            log.debug("Posting event to %s failed", new Object[]{request.getUri()});
            return new EventSubmissionFailedException(this.type, this.pool, (Map<URI, ? extends Throwable>)ImmutableMap.of((Object)request.getUri(), (Object)exception));
        }

        public Void handle(Request request, Response response) {
            int statusCode = response.getStatusCode();
            if (statusCode >= 200 && statusCode <= 299) {
                return null;
            }
            try {
                InputStream inputStream = response.getInputStream();
                String responseBody = CharStreams.toString((Readable)new InputStreamReader(inputStream));
                log.debug("Posting event to %s failed: status_code=%d status_line=%s body=%s", new Object[]{request.getUri(), statusCode, response.getStatusMessage(), responseBody});
            }
            catch (IOException bodyError) {
                log.debug("Posting event to %s failed: status_code=%d status_line=%s error=%s", new Object[]{request.getUri(), statusCode, response.getStatusMessage(), bodyError.getMessage()});
            }
            return null;
        }
    }

    private static class JsonEntityWriter<T>
    implements BodyGenerator {
        private final JsonEventWriter eventWriter;
        private final EventClient.EventGenerator<T> events;

        public JsonEntityWriter(JsonEventWriter eventWriter, EventClient.EventGenerator<T> events) {
            this.eventWriter = (JsonEventWriter)Preconditions.checkNotNull((Object)eventWriter, (Object)"eventWriter is null");
            this.events = (EventClient.EventGenerator)Preconditions.checkNotNull(events, (Object)"events is null");
        }

        public void write(OutputStream out) throws Exception {
            this.eventWriter.writeEvents(this.events, out);
        }
    }
}

