/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.EventSubmissionFailedException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class InMemoryEventClient
implements EventClient {
    private final List<Object> events = Lists.newArrayList();

    @Override
    public <T> CheckedFuture<Void, RuntimeException> post(T ... events) throws IllegalArgumentException {
        return this.post((Iterable<T>)Arrays.asList(events));
    }

    @Override
    public <T> CheckedFuture<Void, RuntimeException> post(Iterable<T> events) throws IllegalArgumentException {
        Preconditions.checkNotNull(events, (Object)"event is null");
        for (T event : events) {
            Preconditions.checkNotNull(event, (Object)"event is null");
            this.events.add(event);
        }
        return Futures.immediateCheckedFuture(null);
    }

    @Override
    public <T> CheckedFuture<Void, RuntimeException> post(EventClient.EventGenerator<T> eventGenerator) throws IllegalArgumentException {
        Preconditions.checkNotNull(eventGenerator, (Object)"eventGenerator is null");
        try {
            eventGenerator.generate(new EventClient.EventPoster<T>(){

                @Override
                public void post(T event) {
                    Preconditions.checkNotNull(event, (Object)"event is null");
                    InMemoryEventClient.this.events.add(event);
                }
            });
        }
        catch (IOException e) {
            return Futures.immediateFailedCheckedFuture((Exception)new EventSubmissionFailedException("event", "general", (Map<URI, ? extends Throwable>)ImmutableMap.of((Object)URI.create("in-memory://"), (Object)e)));
        }
        return Futures.immediateCheckedFuture(null);
    }

    public List<Object> getEvents() {
        return ImmutableList.copyOf(this.events);
    }
}

