/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.event.client.EventClient;
import java.util.Set;
import javax.inject.Inject;

public class MultiEventClient
implements EventClient {
    private final Set<EventClient> clients;

    public MultiEventClient(EventClient ... clients) {
        this((Set<EventClient>)ImmutableSet.copyOf((Object[])clients));
    }

    @Inject
    public MultiEventClient(Set<EventClient> clients) {
        this.clients = clients;
    }

    @Override
    @SafeVarargs
    public final <T> CheckedFuture<Void, RuntimeException> post(T ... event) throws IllegalArgumentException {
        return this.post((Iterable<T>)ImmutableList.copyOf((Object[])event));
    }

    @Override
    public <T> CheckedFuture<Void, RuntimeException> post(Iterable<T> events) throws IllegalArgumentException {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (EventClient client : this.clients) {
            futures.add(client.post(events));
        }
        return new ListCheckedFuture((Iterable<? extends ListenableFuture<Void>>)futures.build());
    }

    @Override
    public <T> CheckedFuture<Void, RuntimeException> post(EventClient.EventGenerator<T> eventGenerator) throws IllegalArgumentException {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (EventClient client : this.clients) {
            futures.add(client.post(eventGenerator));
        }
        return new ListCheckedFuture((Iterable<? extends ListenableFuture<Void>>)futures.build());
    }

    private static class ListCheckedFuture
    extends AbstractCheckedFuture<Void, RuntimeException> {
        public ListCheckedFuture(Iterable<? extends ListenableFuture<Void>> futures) {
            super(Futures.transform((ListenableFuture)Futures.allAsList(futures), (Function)Functions.constant(null)));
        }

        protected RuntimeException mapException(Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

