/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Person {
    private final String email;
    private final String name;

    public Person(String email, String name) {
        Preconditions.checkNotNull((Object)email, (Object)"email is null");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.email = email;
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.email != null ? !this.email.equals(person.email) : person.email != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(person.name) : person.name != null);
    }

    public int hashCode() {
        int result = this.email != null ? this.email.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Person{email='" + this.email + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

