/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.event.client.EventClient;
import io.airlift.sample.Person;
import io.airlift.sample.PersonStoreStats;
import io.airlift.sample.StoreConfig;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class PersonStore {
    private final ConcurrentMap<String, Person> persons;
    private final PersonStoreStats stats;

    @Inject
    public PersonStore(StoreConfig config, EventClient eventClient) {
        Preconditions.checkNotNull((Object)config, (Object)"config must not be null");
        Preconditions.checkNotNull((Object)eventClient, (Object)"eventClient is null");
        Cache personCache = CacheBuilder.newBuilder().expireAfterWrite((long)config.getTtl().toMillis(), TimeUnit.MILLISECONDS).build();
        this.persons = personCache.asMap();
        this.stats = new PersonStoreStats(eventClient);
    }

    @Managed
    @Flatten
    public PersonStoreStats getStats() {
        return this.stats;
    }

    public Person get(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        Person person = (Person)this.persons.get(id);
        if (person != null) {
            this.stats.personFetched();
        }
        return person;
    }

    public boolean put(String id, Person person) {
        boolean added;
        Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        Preconditions.checkNotNull((Object)person, (Object)"person must not be null");
        boolean bl = added = this.persons.put(id, person) == null;
        if (added) {
            this.stats.personAdded(id, person);
        } else {
            this.stats.personUpdated(id, person);
        }
        return added;
    }

    public boolean delete(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        Person removedPerson = (Person)this.persons.remove(id);
        if (removedPerson != null) {
            this.stats.personRemoved(id, removedPerson);
        }
        return removedPerson != null;
    }

    public Collection<Person> getAll() {
        return ImmutableList.copyOf(this.persons.values());
    }
}

