/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.sample.Person;
import io.airlift.sample.PersonRepresentation;
import io.airlift.sample.PersonStore;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/person")
public class PersonsResource {
    private final PersonStore store;

    @Inject
    public PersonsResource(PersonStore store) {
        Preconditions.checkNotNull((Object)store, (Object)"store must not be null");
        this.store = store;
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAll() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Person person : this.store.getAll()) {
            builder.add((Object)PersonRepresentation.from(person, null));
        }
        return Response.ok((Object)builder.build()).build();
    }
}

