/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import java.io.IOException;
import org.joda.time.Instant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantDeserializer
extends JodaDeserializerBase<Instant> {
    public InstantDeserializer() {
        super(Instant.class);
    }

    public Instant deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Instant(jp.getLongValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            return new Instant((Object)str);
        }
        throw ctxt.mappingException(this.getValueClass());
    }
}

