/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;

public class DecayCounter {
    static final long RESCALE_THRESHOLD_SECONDS = 50L;
    private final double alpha;
    private final Ticker ticker;
    private long landmarkInSeconds;
    private double count;

    public DecayCounter(double alpha) {
        this(alpha, Ticker.systemTicker());
    }

    public DecayCounter(double alpha, Ticker ticker) {
        this.alpha = alpha;
        this.ticker = ticker;
        this.landmarkInSeconds = this.getTickInSeconds();
    }

    public synchronized void add(long value) {
        long nowInSeconds = this.getTickInSeconds();
        if (nowInSeconds - this.landmarkInSeconds >= 50L) {
            this.count /= this.weight(nowInSeconds, this.landmarkInSeconds);
            this.landmarkInSeconds = nowInSeconds;
        }
        this.count += (double)value * this.weight(nowInSeconds, this.landmarkInSeconds);
    }

    @Managed
    public synchronized double getCount() {
        long nowInSeconds = this.getTickInSeconds();
        return this.count / this.weight(nowInSeconds, this.landmarkInSeconds);
    }

    @Managed
    public synchronized double getRate() {
        return this.getCount() * this.alpha;
    }

    private double weight(long timestampInSeconds, long landmarkInSeconds) {
        return Math.exp(this.alpha * (double)(timestampInSeconds - landmarkInSeconds));
    }

    private long getTickInSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(this.ticker.read());
    }

    public DecayCounterSnapshot snapshot() {
        return new DecayCounterSnapshot(this.getCount(), this.getRate());
    }

    public static class DecayCounterSnapshot {
        private final double count;
        private final double rate;

        @JsonCreator
        public DecayCounterSnapshot(@JsonProperty(value="count") double count, @JsonProperty(value="rate") double rate) {
            this.count = count;
            this.rate = rate;
        }

        @JsonProperty
        public double getCount() {
            return this.count;
        }

        @JsonProperty
        public double getRate() {
            return this.rate;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("count", this.count).add("rate", this.rate).toString();
        }
    }
}

