/*
 * Decompiled with CFR 0.152.
 */
package pl.com.softproject.utils.xml;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DataTools {
    private static final int MILLISECONDS_IN_DAY = 86400000;

    public static long countDaysBetween(Date start, Date end) {
        if (end.before(start)) {
            return 0L;
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(start);
        startCal.set(11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        long startTime = startCal.getTimeInMillis();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(end);
        endCal.set(11, 0);
        endCal.set(12, 0);
        endCal.set(13, 0);
        long endTime = endCal.getTimeInMillis();
        return (endTime - startTime) / 86400000L;
    }

    public static Date convertXMLCalendar(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar toXMLCalendar(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        try {
            XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(c.get(1), c.get(2) + 1, c.get(5), 0);
            return xmlCal;
        }
        catch (DatatypeConfigurationException ex) {
            return null;
        }
    }

    public static Date addDaysToDate(Date start, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static String formatDateWithTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sXXX");
        return df.format(date);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }
}

