/*
 * Decompiled with CFR 0.152.
 */
package pl.com.softproject.utils.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.util.JAXBSource;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import pl.com.softproject.utils.xml.XMLParseException;

public class XMLValidator {
    private static final Logger log = LoggerFactory.getLogger(XMLValidator.class);

    public static boolean checkSyntax(Reader reader, Collection<SAXParseException> errors) throws ParserConfigurationException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new XMLErrorHandler(errors));
        InputSource source = new InputSource(reader);
        try {
            builder.parse(source);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return errors.isEmpty();
    }

    public static boolean validate(Reader reader, Source schemaSource, Collection<SAXParseException> errors) throws SAXException, IOException {
        return XMLValidator.validate(reader, new Source[]{schemaSource}, errors);
    }

    public static boolean validate(Reader reader, Source schemaSource, Collection<SAXParseException> errors, Set<SchemaFactoryFeature> features) throws SAXException, IOException {
        return XMLValidator.validate(reader, new Source[]{schemaSource}, errors, features);
    }

    public static boolean validate(Reader reader, Source[] schemaSource, Collection<SAXParseException> errors) throws SAXException, IOException {
        return XMLValidator.validate(reader, schemaSource, errors, Set.of());
    }

    public static boolean validate(Reader reader, Source[] schemaSource, Collection<SAXParseException> errors, Set<SchemaFactoryFeature> features) throws SAXException, IOException {
        errors.clear();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        features.forEach(feature -> {
            try {
                factory.setFeature(feature.key, feature.value);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                log.warn(e.getMessage());
            }
        });
        Schema schema = schemaSource == null ? factory.newSchema() : factory.newSchema(schemaSource);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(reader);
        validator.setErrorHandler(new XMLErrorHandler(errors));
        validator.validate(source);
        return errors.isEmpty();
    }

    public static boolean validate(Reader reader, Collection<SAXParseException> errors) throws SAXException, IOException {
        return XMLValidator.validate(reader, (Source)null, errors);
    }

    public static <T> boolean validateJaxbObject(T jaxbObject, Source xsdFSource, List<SAXParseException> exceptions) {
        try {
            String contextPath = jaxbObject.getClass().getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance((String)contextPath);
            JAXBSource source = new JAXBSource(jc, jaxbObject);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = xsdFSource == null ? factory.newSchema() : factory.newSchema(xsdFSource);
            Validator validator = schema.newValidator();
            if (exceptions == null) {
                exceptions = new ArrayList<SAXParseException>();
            } else {
                exceptions.clear();
            }
            validator.setErrorHandler(new XMLErrorExtensionHandler(exceptions));
            validator.validate((Source)source);
            return exceptions.isEmpty();
        }
        catch (JAXBException | SAXException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static String getNemespaceFromXMLDocument(Reader reader) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder parser = null;
        InputSource source = null;
        try {
            parser = dbf.newDocumentBuilder();
            source = new InputSource(reader);
            Document document = parser.parse(source);
            return document.getChildNodes().item(0).getNamespaceURI();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            log.error("cannot open file to parse");
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static class XMLErrorHandler
    implements ErrorHandler {
        private Collection<SAXParseException> errors;

        XMLErrorHandler(Collection<SAXParseException> errors) {
            this.errors = errors;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }
    }

    public static class XMLErrorExtensionHandler
    extends XMLErrorHandler {
        XMLErrorExtensionHandler(List<SAXParseException> exceptions) {
            super(exceptions);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            String message = exception.getMessage() != null ? exception.getMessage() : "";
            log.warn(message, (Throwable)exception);
        }
    }

    public static final class SchemaFactoryFeature {
        private final String key;
        private final boolean value;

        public SchemaFactoryFeature(String key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaFactoryFeature)) {
                return false;
            }
            SchemaFactoryFeature other = (SchemaFactoryFeature)o;
            if (this.isValue() != other.isValue()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValue() ? 79 : 97);
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        public String toString() {
            return "XMLValidator.SchemaFactoryFeature(key=" + this.getKey() + ", value=" + this.isValue() + ")";
        }
    }
}

