/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.tests;

import io.apicurio.registry.client.CompatibleClient;
import io.apicurio.registry.client.RegistryClient;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.apicurio.registry.utils.tests.TestUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;

public class RegistryServiceExtension
implements TestTemplateInvocationContextProvider {
    private static final String REGISTRY_CLIENT_CREATE = "create";
    private static final String REGISTRY_CLIENT_CACHED = "cached";
    private static final String REGISTRY_CLIENT_COMPATIBLE = "createCompatible";
    private static final String REGISTRY_CLIENT_ALL = "all";

    private static ParameterType getParameterType(Type type) {
        if (type instanceof Class) {
            if (type == RegistryService.class) {
                return ParameterType.REGISTRY_SERVICE;
            }
        } else if (type instanceof ParameterizedType) {
            Type[] arguments;
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            if (rawType == RegistryService.class) {
                return ParameterType.REGISTRY_SERVICE;
            }
            if (rawType == Supplier.class && (arguments = pt.getActualTypeArguments())[0] == RegistryService.class) {
                return ParameterType.SUPPLIER;
            }
        }
        return ParameterType.UNSUPPORTED;
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return context.getTestMethod().map(method -> {
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (RegistryServiceExtension.getParameterType(method.getGenericParameterTypes()[i]) == ParameterType.UNSUPPORTED) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        AnnotationUtils.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), RegistryServiceTest.class).orElseThrow(IllegalStateException::new);
        String registryUrl = TestUtils.getRegistryApiUrl();
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.GLOBAL);
        ArrayList<RegistryServiceTestTemplateInvocationContext> invocationCtxts = new ArrayList<RegistryServiceTestTemplateInvocationContext>();
        if (this.testRegistryClient(REGISTRY_CLIENT_CREATE)) {
            RegistryServiceWrapper plain = (RegistryServiceWrapper)store.getOrComputeIfAbsent((Object)"plain_client", k -> new RegistryServiceWrapper((String)k, REGISTRY_CLIENT_CREATE, registryUrl), RegistryServiceWrapper.class);
            invocationCtxts.add(new RegistryServiceTestTemplateInvocationContext(plain, context.getRequiredTestMethod()));
        }
        if (this.testRegistryClient(REGISTRY_CLIENT_COMPATIBLE)) {
            RegistryServiceWrapper compatible = (RegistryServiceWrapper)store.getOrComputeIfAbsent((Object)"compatible_client", k -> new RegistryServiceWrapper((String)k, REGISTRY_CLIENT_COMPATIBLE, registryUrl + "/"), RegistryServiceWrapper.class);
            invocationCtxts.add(new RegistryServiceTestTemplateInvocationContext(compatible, context.getRequiredTestMethod()));
        }
        if (this.testRegistryClient(REGISTRY_CLIENT_CACHED)) {
            RegistryServiceWrapper cached = (RegistryServiceWrapper)store.getOrComputeIfAbsent((Object)"cached_client", k -> new RegistryServiceWrapper((String)k, REGISTRY_CLIENT_CACHED, registryUrl), RegistryServiceWrapper.class);
            invocationCtxts.add(new RegistryServiceTestTemplateInvocationContext(cached, context.getRequiredTestMethod()));
        }
        return invocationCtxts.stream();
    }

    private boolean testRegistryClient(String clientType) {
        String testRegistryClients = TestUtils.getTestRegistryClients();
        return testRegistryClients == null || testRegistryClients.equalsIgnoreCase(REGISTRY_CLIENT_ALL) || testRegistryClients.equalsIgnoreCase(clientType);
    }

    private static boolean isTestAllClientTypes() {
        String testRegistryClients = TestUtils.getTestRegistryClients();
        return testRegistryClients == null || testRegistryClients.equalsIgnoreCase(REGISTRY_CLIENT_ALL);
    }

    private static class RegistryServiceTestTemplateInvocationContext
    implements TestTemplateInvocationContext,
    ParameterResolver {
        private RegistryServiceWrapper wrapper;
        private Method testMethod;

        public RegistryServiceTestTemplateInvocationContext(RegistryServiceWrapper wrapper, Method testMethod) {
            this.wrapper = wrapper;
            this.testMethod = testMethod;
        }

        public String getDisplayName(int invocationIndex) {
            if (RegistryServiceExtension.isTestAllClientTypes()) {
                return String.format("%s (%s) [%s]", this.testMethod.getName(), this.wrapper.key, invocationIndex);
            }
            return this.testMethod.getName();
        }

        public List<Extension> getAdditionalExtensions() {
            return Collections.singletonList(this);
        }

        public boolean supportsParameter(ParameterContext pc, ExtensionContext ec) throws ParameterResolutionException {
            Parameter parameter = pc.getParameter();
            return RegistryServiceExtension.getParameterType(parameter.getParameterizedType()) != ParameterType.UNSUPPORTED;
        }

        public Object resolveParameter(ParameterContext pc, ExtensionContext ec) throws ParameterResolutionException {
            Parameter parameter = pc.getParameter();
            ParameterType type = RegistryServiceExtension.getParameterType(parameter.getParameterizedType());
            switch (type) {
                case REGISTRY_SERVICE: {
                    return this.wrapper.service = (AutoCloseable)this.createRegistryService();
                }
                case SUPPLIER: {
                    switch (this.wrapper.method) {
                        case "all": 
                        case "cached": 
                        case "create": {
                            return this.getSupplier(RegistryClient.class.getName());
                        }
                        case "createCompatible": {
                            return this.getSupplier(CompatibleClient.class.getName());
                        }
                    }
                }
            }
            throw new IllegalStateException("Invalid parameter type: " + (Object)((Object)type));
        }

        private Supplier<Object> getSupplier(String clientClassName) {
            return () -> {
                if (this.wrapper.service == null) {
                    try {
                        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                        if (tccl == null || tccl == ExtensionContext.class.getClassLoader()) {
                            this.wrapper.service = (AutoCloseable)this.createRegistryService();
                        } else {
                            Class<?> clientClass = tccl.loadClass(clientClassName);
                            Method factoryMethod = clientClass.getMethod(this.wrapper.method, String.class);
                            this.wrapper.service = (AutoCloseable)factoryMethod.invoke(null, this.wrapper.registryUrl);
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                return this.wrapper.service;
            };
        }

        private RegistryService createRegistryService() {
            switch (this.wrapper.method) {
                case "create": {
                    return RegistryClient.create((String)this.wrapper.registryUrl);
                }
                case "createCompatible": {
                    return CompatibleClient.createCompatible((String)this.wrapper.registryUrl);
                }
                case "cached": {
                    return RegistryClient.cached((String)this.wrapper.registryUrl);
                }
            }
            throw new IllegalArgumentException("Unsupported registry client method: " + this.wrapper.method);
        }
    }

    private static class RegistryServiceWrapper
    implements ExtensionContext.Store.CloseableResource {
        private String key;
        private String method;
        private String registryUrl;
        private volatile AutoCloseable service;

        public RegistryServiceWrapper(String key, String method, String registryUrl) {
            this.key = key;
            this.method = method;
            this.registryUrl = registryUrl;
        }

        public void close() throws Throwable {
            IoUtil.close((AutoCloseable)this.service);
        }
    }

    private static enum ParameterType {
        REGISTRY_SERVICE,
        SUPPLIER,
        UNSUPPORTED;

    }
}

