/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.tests;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.utils.IoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.ws.rs.WebApplicationException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);
    private static final String DEFAULT_REGISTRY_HOST = "localhost";
    private static final int DEFAULT_REGISTRY_PORT = 8081;
    private static final String REGISTRY_HOST = System.getenv().getOrDefault("REGISTRY_HOST", "localhost");
    private static final int REGISTRY_PORT = Integer.parseInt(System.getenv().getOrDefault("REGISTRY_PORT", String.valueOf(8081)));
    private static final String EXTERNAL_REGISTRY = System.getenv().getOrDefault("EXTERNAL_REGISTRY", "false");
    private static final String TEST_REGISTRY_CLIENT = System.getenv("TEST_REGISTRY_CLIENT");

    private TestUtils() {
    }

    public static boolean isExternalRegistry() {
        return Boolean.parseBoolean(EXTERNAL_REGISTRY);
    }

    public static String getRegistryHost() {
        return REGISTRY_HOST;
    }

    public static int getRegistryPort() {
        return REGISTRY_PORT;
    }

    public static String getRegistryUIUrl() {
        return TestUtils.getRegistryUrl().concat("/ui");
    }

    public static String getRegistryApiUrl() {
        return TestUtils.getRegistryUrl().concat("/api");
    }

    private static String getRegistryUrl() {
        if (TestUtils.isExternalRegistry()) {
            return String.format("http://%s:%s", REGISTRY_HOST, REGISTRY_PORT);
        }
        return String.format("http://%s:%s", DEFAULT_REGISTRY_HOST, 8081);
    }

    public static String getTestRegistryClients() {
        return TEST_REGISTRY_CLIENT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReachable() {
        try (Socket socket = new Socket();){
            String host = TestUtils.isExternalRegistry() ? REGISTRY_HOST : DEFAULT_REGISTRY_HOST;
            int port = TestUtils.isExternalRegistry() ? REGISTRY_PORT : 8081;
            log.info("Trying to connect to {}:{}", (Object)host, (Object)port);
            socket.connect(new InetSocketAddress(host, port), 5000);
            log.info("Client is able to connect to Registry instance");
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            log.warn("Cannot connect to Registry instance: {}", (Object)ex.getMessage());
            return false;
        }
    }

    public static boolean isReady(boolean logResponse) {
        try {
            boolean ok;
            CloseableHttpResponse res = HttpClients.createMinimal().execute((HttpUriRequest)new HttpGet(TestUtils.getRegistryUrl().concat("/health/ready")));
            boolean bl = ok = res.getStatusLine().getStatusCode() == 200;
            if (ok) {
                log.info("Service registry is ready");
            }
            if (logResponse) {
                log.info(IoUtil.toString((InputStream)res.getEntity().getContent()));
            }
            return ok;
        }
        catch (IOException e) {
            log.warn("Service registry is not ready {}", (Object)e.getMessage());
            return false;
        }
    }

    public static long waitFor(String description, long pollIntervalMs, long timeoutMs, BooleanSupplier ready) throws TimeoutException {
        return TestUtils.waitFor(description, pollIntervalMs, timeoutMs, ready, () -> {});
    }

    public static long waitFor(String description, long pollIntervalMs, long timeoutMs, BooleanSupplier ready, Runnable onTimeout) throws TimeoutException {
        log.debug("Waiting for {}", (Object)description);
        long deadline = System.currentTimeMillis() + timeoutMs;
        while (true) {
            boolean result;
            try {
                result = ready.getAsBoolean();
            }
            catch (Exception e) {
                result = false;
            }
            long timeLeft = deadline - System.currentTimeMillis();
            if (result) {
                return timeLeft;
            }
            if (timeLeft <= 0L) {
                onTimeout.run();
                TimeoutException exception = new TimeoutException("Timeout after " + timeoutMs + " ms waiting for " + description);
                exception.printStackTrace();
                throw exception;
            }
            long sleepTime = Math.min(pollIntervalMs, timeLeft);
            if (log.isTraceEnabled()) {
                log.trace("{} not ready, will try again in {} ms ({}ms till timeout)", new Object[]{description, sleepTime, timeLeft});
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                return deadline - System.currentTimeMillis();
            }
        }
    }

    public static void writeFile(String filePath, String text) {
        try {
            Files.write(new File(filePath).toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.info("Exception during writing text in file");
        }
    }

    public static void writeFile(Path filePath, String text) {
        try {
            Files.write(filePath, text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.info("Exception during writing text in file");
        }
    }

    public static String generateTopic() {
        return TestUtils.generateTopic("topic-");
    }

    public static String generateTopic(String prefix) {
        return prefix + UUID.randomUUID().toString();
    }

    public static String generateSubject() {
        return "s" + TestUtils.generateArtifactId().replace("-", "x");
    }

    public static String generateArtifactId() {
        return UUID.randomUUID().toString();
    }

    public static void retry(RunnableExc runnable) throws Exception {
        TestUtils.retry(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T retry(Callable<T> callable) throws Exception {
        return TestUtils.retry(callable, "Action #" + System.currentTimeMillis(), 15);
    }

    public static void retry(RunnableExc runnable, String name, int maxRetries) throws Exception {
        TestUtils.retry(() -> {
            runnable.run();
            return null;
        }, name, maxRetries);
    }

    public static <T> T retry(Callable<T> callable, String name, int maxRetries) throws Exception {
        Throwable error = null;
        int tries = maxRetries;
        int attempt = 1;
        while (tries > 0) {
            try {
                if (attempt > 1) {
                    log.debug("Retrying action [{}].  Attempt #{}", (Object)name, (Object)attempt);
                }
                return callable.call();
            }
            catch (Throwable t) {
                if (error == null) {
                    error = t;
                } else {
                    error.addSuppressed(t);
                }
                Thread.sleep(100L * (long)attempt);
                --tries;
                ++attempt;
            }
        }
        log.debug("Action [{}] failed after {} attempts.", (Object)name, (Object)attempt);
        Assertions.assertTrue((tries > 0 ? 1 : 0) != 0, (String)String.format("Failed handle callable: %s [%s]", callable, error));
        throw new IllegalStateException("Should not be here!");
    }

    public static void assertWebError(int expectedCode, Runnable runnable) {
        try {
            TestUtils.assertWebError(expectedCode, runnable, false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void assertWebError(int expectedCode, Runnable runnable, boolean retry) throws Exception {
        if (retry) {
            TestUtils.retry(() -> TestUtils.internalAssertWebError(expectedCode, runnable));
        } else {
            TestUtils.internalAssertWebError(expectedCode, runnable);
        }
    }

    private static void internalAssertWebError(int expectedCode, Runnable runnable) {
        try {
            runnable.run();
            Assertions.fail((String)("Expected (but didn't get) a web application exception with code: " + expectedCode));
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)WebApplicationException.class.getName(), (Object)e.getClass().getName(), () -> "e: " + e);
            Assertions.assertEquals((int)expectedCode, (int)((WebApplicationException)WebApplicationException.class.cast(e)).getResponse().getStatus());
        }
    }

    public static void waitForSchema(RegistryService service, byte[] bytes) throws Exception {
        TestUtils.waitForSchema(service, bytes, ByteBuffer::getLong);
    }

    public static void waitForSchema(RegistryService service, byte[] bytes, Function<ByteBuffer, Long> fn) throws Exception {
        TestUtils.waitForSchemaCustom(service, bytes, input -> {
            ByteBuffer buffer = ByteBuffer.wrap(input);
            buffer.get();
            return (Long)fn.apply(buffer);
        });
    }

    public static void waitForSchemaCustom(RegistryService service, byte[] bytes, Function<byte[], Long> fn) throws Exception {
        service.reset();
        long id = fn.apply(bytes);
        ArtifactMetaData amd = TestUtils.retry(() -> service.getArtifactMetaDataByGlobalId(id));
        Assertions.assertNotNull((Object)amd);
    }

    @FunctionalInterface
    public static interface RunnableExc {
        public void run() throws Exception;
    }
}

