/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ConfigFileConfiguration
extends PropertiesConfiguration {
    private ConfigFileConfiguration(String configFileName, String customConfigPropertyName) throws ConfigurationException {
        super(ConfigFileConfiguration.discoverConfigFileUrl(configFileName, customConfigPropertyName));
    }

    protected static URL findConfigUrlInDirectory(File directory, String configName) {
        File cfile;
        if (directory.isDirectory() && (cfile = new File(directory, configName)).isFile()) {
            try {
                return cfile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static ConfigFileConfiguration create(String configFileName, String customConfigPropertyName) {
        try {
            return new ConfigFileConfiguration(configFileName, customConfigPropertyName);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to find configuration file: " + configFileName, e);
        }
    }

    private static URL discoverConfigFileUrl(String configFileName, String customConfigPropertyName) {
        File dirFile;
        File dirFile2;
        URL rval;
        String userConfig = System.getProperty(customConfigPropertyName);
        if (userConfig != null) {
            try {
                URL rval2 = new URL(userConfig);
                return rval2;
            }
            catch (Exception exception) {
                try {
                    File f = new File(userConfig);
                    if (f.isFile()) {
                        URL rval3 = f.toURI().toURL();
                        return rval3;
                    }
                }
                catch (Exception f) {
                    // empty catch block
                }
                throw new RuntimeException("Apiman configuration provided at [" + userConfig + "] but could not be loaded.");
            }
        }
        String jbossConfigDir = System.getProperty("jboss.server.config.dir");
        String jbossConfigUrl = System.getProperty("jboss.server.config.url");
        if (jbossConfigDir != null && (rval = ConfigFileConfiguration.findConfigUrlInDirectory(dirFile2 = new File(jbossConfigDir), configFileName)) != null) {
            return rval;
        }
        if (jbossConfigUrl != null && (rval = ConfigFileConfiguration.findConfigUrlInDirectory(dirFile2 = new File(jbossConfigUrl), configFileName)) != null) {
            return rval;
        }
        String tomcatHomeDir = System.getProperty("catalina.home");
        if (tomcatHomeDir != null && (rval = ConfigFileConfiguration.findConfigUrlInDirectory(dirFile = new File(tomcatHomeDir, "conf"), configFileName)) != null) {
            return rval;
        }
        return ConfigFileConfiguration.class.getResource("empty.properties");
    }
}

