/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.logging.impl;

import io.apiman.common.logging.IApimanLogger;

public class StringBuilderLogger
implements IApimanLogger {
    private StringBuilder builder = new StringBuilder();

    @Override
    public void info(String message) {
        this.append("INFO: " + message);
    }

    @Override
    public void info(String message, Object ... args) {
        this.append(String.format(message, args));
    }

    @Override
    public void warn(String message) {
        this.append("WARN: " + message);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.append(String.format(message, args));
    }

    @Override
    public void debug(String message) {
        this.append("DEBUG: " + message);
    }

    @Override
    public void debug(String message, Object ... args) {
        this.append(String.format(message, args));
    }

    @Override
    public void trace(String message) {
        this.append("TRACE: " + message);
    }

    @Override
    public void trace(String message, Object ... args) {
        this.append(String.format(message, args));
    }

    @Override
    public void error(Throwable error) {
        this.append("ERROR: " + error.getMessage());
    }

    @Override
    public void error(String message, Throwable error) {
        this.append("ERROR: " + message);
    }

    @Override
    public void error(Throwable error, String message, Object ... args) {
        this.append(String.format(message, args));
    }

    private void append(String message) {
        this.builder.append(message);
        this.builder.append("\n");
    }

    public String string() {
        return this.builder.toString();
    }

    public void reset() {
        this.builder = new StringBuilder();
    }
}

