/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.plugin.PluginSpec;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class PluginUtils {
    public static final String PLUGIN_SPEC_PATH = "META-INF/apiman/plugin.json";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Set<URI> MAVEN_REPOSITORIES = new HashSet<URI>();

    private PluginUtils() {
    }

    public static Set<URI> getDefaultMavenRepositories() {
        return MAVEN_REPOSITORIES;
    }

    public static String getPluginRelativePath(PluginCoordinates coordinates) {
        StringBuilder pluginRelativePath = new StringBuilder();
        pluginRelativePath.append(coordinates.getGroupId());
        pluginRelativePath.append("/");
        pluginRelativePath.append(coordinates.getArtifactId());
        pluginRelativePath.append("/");
        pluginRelativePath.append(coordinates.getVersion());
        pluginRelativePath.append("/");
        pluginRelativePath.append(coordinates.getArtifactId());
        if (coordinates.getClassifier() != null) {
            pluginRelativePath.append("-").append(coordinates.getClassifier());
        }
        pluginRelativePath.append(".");
        pluginRelativePath.append(coordinates.getType());
        return pluginRelativePath.toString();
    }

    public static PluginSpec readPluginSpecFile(URL pluginSpec) throws IOException {
        return (PluginSpec)mapper.reader(PluginSpec.class).readValue(pluginSpec);
    }

    public static File getUserM2Repository() {
        File m2Dir;
        File userHomeDir;
        String m2Override = System.getProperty("apiman.gateway.m2-repository-path");
        if (m2Override != null) {
            return new File(m2Override).getAbsoluteFile();
        }
        String userHome = System.getProperty("user.home");
        if (userHome != null && (userHomeDir = new File(userHome)).isDirectory() && (m2Dir = new File(userHome, ".m2/repository")).isDirectory()) {
            return m2Dir;
        }
        return null;
    }

    public static File getM2Path(File m2Dir, PluginCoordinates coordinates) {
        String artifactSubPath = PluginUtils.getMavenPath(coordinates);
        return new File(m2Dir, artifactSubPath);
    }

    public static String getMavenPath(PluginCoordinates coordinates) {
        StringBuilder artifactSubPath = new StringBuilder();
        artifactSubPath.append(coordinates.getGroupId().replace('.', '/'));
        artifactSubPath.append('/');
        artifactSubPath.append(coordinates.getArtifactId());
        artifactSubPath.append('/');
        artifactSubPath.append(coordinates.getVersion());
        artifactSubPath.append('/');
        artifactSubPath.append(coordinates.getArtifactId());
        artifactSubPath.append('-');
        artifactSubPath.append(coordinates.getVersion());
        if (coordinates.getClassifier() != null) {
            artifactSubPath.append('-');
            artifactSubPath.append(coordinates.getClassifier());
        }
        artifactSubPath.append('.');
        artifactSubPath.append(coordinates.getType());
        return artifactSubPath.toString();
    }

    public static boolean isSnapshot(PluginCoordinates coordinates) {
        return coordinates.getVersion().endsWith("-SNAPSHOT");
    }

    static {
        try {
            MAVEN_REPOSITORIES.add(new URI("https://repo1.maven.org/maven2/"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

