/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.internal.filters.AppiumIdempotencyFilter;
import io.appium.java_client.internal.filters.AppiumUserAgentFilter;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Filter;

public class AppiumClientConfig
extends ClientConfig {
    private final boolean directConnect;
    private static final Filter DEFAULT_FILTERS = new AppiumUserAgentFilter().andThen(new AppiumIdempotencyFilter());
    private static final String DEFAULT_HTTP_VERSION = "HTTP_1_1";
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(10L);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(10L);

    protected AppiumClientConfig(URI baseUri, Duration connectionTimeout, Duration readTimeout, Filter filters, @Nullable Proxy proxy, @Nullable Credentials credentials, @Nullable SSLContext sslContext, @Nullable String version, Boolean directConnect) {
        super(baseUri, connectionTimeout, readTimeout, filters, proxy, credentials, sslContext, version);
        this.directConnect = (Boolean)Require.nonNull((String)"Direct Connect", (Object)directConnect);
    }

    public static AppiumClientConfig defaultConfig() {
        return new AppiumClientConfig(null, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT, DEFAULT_FILTERS, null, null, null, DEFAULT_HTTP_VERSION, false);
    }

    public static AppiumClientConfig fromClientConfig(ClientConfig clientConfig) {
        return new AppiumClientConfig(clientConfig.baseUri(), clientConfig.connectionTimeout(), clientConfig.readTimeout(), clientConfig.filter(), clientConfig.proxy(), clientConfig.credentials(), clientConfig.sslContext(), clientConfig.version(), false);
    }

    private AppiumClientConfig buildAppiumClientConfig(ClientConfig clientConfig, Boolean directConnect) {
        return new AppiumClientConfig(clientConfig.baseUri(), clientConfig.connectionTimeout(), clientConfig.readTimeout(), clientConfig.filter(), clientConfig.proxy(), clientConfig.credentials(), clientConfig.sslContext(), clientConfig.version(), directConnect);
    }

    public AppiumClientConfig baseUri(URI baseUri) {
        ClientConfig clientConfig = super.baseUri(baseUri);
        return this.buildAppiumClientConfig(clientConfig, this.directConnect);
    }

    public AppiumClientConfig baseUrl(URL baseUrl) {
        try {
            return this.baseUri(((URL)Require.nonNull((String)"Base URL", (Object)baseUrl)).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public AppiumClientConfig connectionTimeout(Duration timeout) {
        ClientConfig clientConfig = super.connectionTimeout(timeout);
        return this.buildAppiumClientConfig(clientConfig, this.directConnect);
    }

    public AppiumClientConfig readTimeout(Duration timeout) {
        ClientConfig clientConfig = super.readTimeout(timeout);
        return this.buildAppiumClientConfig(clientConfig, this.directConnect);
    }

    public AppiumClientConfig withFilter(Filter filter) {
        ClientConfig clientConfig = super.withFilter(filter);
        return this.buildAppiumClientConfig(clientConfig, this.directConnect);
    }

    public AppiumClientConfig withRetries() {
        ClientConfig clientConfig = super.withRetries();
        return this.buildAppiumClientConfig(clientConfig, this.directConnect);
    }

    public AppiumClientConfig proxy(Proxy proxy) {
        ClientConfig clientConfig = super.proxy(proxy);
        return this.buildAppiumClientConfig(clientConfig, this.directConnect);
    }

    public AppiumClientConfig authenticateAs(Credentials credentials) {
        ClientConfig clientConfig = super.authenticateAs(credentials);
        return this.buildAppiumClientConfig(clientConfig, this.directConnect);
    }

    public AppiumClientConfig directConnect(boolean directConnect) {
        return new AppiumClientConfig(this.baseUri(), this.connectionTimeout(), this.readTimeout(), this.filter(), this.proxy(), this.credentials(), this.sslContext(), this.version(), directConnect);
    }

    public boolean isDirectConnectEnabled() {
        return this.directConnect;
    }

    public String toString() {
        return "AppiumClientConfig{baseUri=" + String.valueOf(this.baseUri()) + ", connectionTimeout=" + String.valueOf(this.connectionTimeout()) + ", readTimeout=" + String.valueOf(this.readTimeout()) + ", filters=" + String.valueOf(this.filter()) + ", proxy=" + String.valueOf(this.proxy()) + ", credentials=" + String.valueOf(this.credentials()) + ", sslcontext=" + String.valueOf(this.sslContext()) + ", version=" + this.version() + ", directConnect=" + this.directConnect + "}";
    }
}

