/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.ThrowableUtil;
import io.appium.java_client.pagefactory.Widget;
import io.appium.java_client.pagefactory.WidgetInterceptor;
import io.appium.java_client.pagefactory.bys.ContentType;
import io.appium.java_client.pagefactory.interceptors.InterceptorOfAListOfElements;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import io.appium.java_client.pagefactory.utils.ProxyFactory;
import io.appium.java_client.pagefactory.utils.WebDriverUnpackUtility;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WidgetListInterceptor
extends InterceptorOfAListOfElements {
    private final Map<ContentType, Constructor<? extends Widget>> instantiationMap;
    private final List<Widget> cachedWidgets = new ArrayList<Widget>();
    private final Class<? extends Widget> declaredType;
    private final Duration duration;
    private final WeakReference<WebDriver> driver;
    private final List<WeakReference<WebElement>> cachedElementReferences = new ArrayList<WeakReference<WebElement>>();

    public WidgetListInterceptor(@Nullable CacheableLocator locator, WeakReference<WebDriver> driver, Map<ContentType, Constructor<? extends Widget>> instantiationMap, Class<? extends Widget> declaredType, Duration duration) {
        super(locator);
        this.instantiationMap = instantiationMap;
        this.declaredType = declaredType;
        this.duration = duration;
        this.driver = driver;
    }

    @Override
    protected Object getObject(List<WebElement> elements, Method method, Object[] args) throws Throwable {
        List cachedElements = this.cachedElementReferences.stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (cachedElements.size() != this.cachedWidgets.size() || this.locator != null && !((CacheableLocator)this.locator).isLookUpCached()) {
            this.cachedWidgets.clear();
            this.cachedElementReferences.clear();
            ContentType type = null;
            for (WebElement element : elements) {
                type = Optional.ofNullable(type).orElseGet(() -> WebDriverUnpackUtility.getCurrentContentType((SearchContext)element));
                Class[] params = new Class[]{this.instantiationMap.get((Object)type).getParameterTypes()[0]};
                WeakReference<WebElement> elementReference = new WeakReference<WebElement>(element);
                this.cachedWidgets.add(ProxyFactory.getEnhancedProxy(this.declaredType, params, new Object[]{element}, new WidgetInterceptor(null, this.driver, elementReference, this.instantiationMap, this.duration)));
                this.cachedElementReferences.add(elementReference);
            }
        }
        try {
            return method.invoke(this.cachedWidgets, args);
        }
        catch (Throwable t) {
            throw ThrowableUtil.extractReadableException(t);
        }
    }
}

