/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import io.appium.java_client.CanRememberExtensionPresence;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.android.GsmCallActions;
import io.appium.java_client.android.GsmSignalStrength;
import io.appium.java_client.android.GsmVoiceState;
import io.appium.java_client.android.NetworkSpeed;
import io.appium.java_client.android.PowerACState;
import java.util.Map;
import org.openqa.selenium.UnsupportedCommandException;

public interface SupportsSpecialEmulatorCommands
extends ExecutesMethod,
CanRememberExtensionPresence {
    default public void sendSMS(String phoneNumber, String message) {
        String extName = "mobile: sendSms";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: sendSms"), "mobile: sendSms", Map.of("phoneNumber", phoneNumber, "message", message));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: sendSms"), Map.entry(MobileCommand.SEND_SMS, Map.of("phoneNumber", phoneNumber, "message", message)));
        }
    }

    default public void makeGsmCall(String phoneNumber, GsmCallActions gsmCallAction) {
        String extName = "mobile: gsmCall";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: gsmCall"), "mobile: gsmCall", Map.of("phoneNumber", phoneNumber, "action", gsmCallAction.toString().toLowerCase()));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: gsmCall"), Map.entry(MobileCommand.GSM_CALL, Map.of("phoneNumber", phoneNumber, "action", gsmCallAction.toString().toLowerCase())));
        }
    }

    default public void setGsmSignalStrength(GsmSignalStrength gsmSignalStrength) {
        String extName = "mobile: gsmSignal";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: gsmSignal"), "mobile: gsmSignal", Map.of("strength", gsmSignalStrength.ordinal()));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: gsmSignal"), Map.entry(MobileCommand.GSM_SIGNAL, Map.of("signalStrengh", gsmSignalStrength.ordinal(), "signalStrength", gsmSignalStrength.ordinal())));
        }
    }

    default public void setGsmVoice(GsmVoiceState gsmVoiceState) {
        String extName = "mobile: gsmVoice";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: gsmVoice"), "mobile: gsmVoice", Map.of("state", gsmVoiceState.toString().toLowerCase()));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: gsmVoice"), Map.entry(MobileCommand.GSM_VOICE, Map.of("state", gsmVoiceState.name().toLowerCase())));
        }
    }

    default public void setNetworkSpeed(NetworkSpeed networkSpeed) {
        String extName = "mobile: networkSpeed";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: networkSpeed"), "mobile: networkSpeed", Map.of("speed", networkSpeed.toString().toLowerCase()));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: networkSpeed"), Map.entry(MobileCommand.NETWORK_SPEED, Map.of("netspeed", networkSpeed.name().toLowerCase())));
        }
    }

    default public void setPowerCapacity(int percent) {
        String extName = "mobile: powerCapacity";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: powerCapacity"), "mobile: powerCapacity", Map.of("percent", percent));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: powerCapacity"), Map.entry(MobileCommand.POWER_CAPACITY, Map.of("percent", percent)));
        }
    }

    default public void setPowerAC(PowerACState powerACState) {
        String extName = "mobile: powerAC";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: powerAC"), "mobile: powerAC", Map.of("state", powerACState.toString().toLowerCase()));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: powerAC"), Map.entry(MobileCommand.POWER_AC_STATE, Map.of("state", powerACState.name().toLowerCase())));
        }
    }
}

