/*
 * Decompiled with CFR 0.152.
 */
package io.appwrite.cookies.stores;

import android.os.Build;
import android.util.Log;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0016J\u0015\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0016J\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001c\u0010 \u001a\u00020\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010!\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lio/appwrite/cookies/stores/InMemoryCookieStore;", "Ljava/net/CookieStore;", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "uriIndex", "", "Ljava/net/URI;", "", "Ljava/net/HttpCookie;", "getUriIndex$library_release", "()Ljava/util/Map;", "add", "", "uri", "cookie", "addIndex", "index", "get", "", "getCookies", "getEffectiveURI", "getEffectiveURI$library_release", "getInternal1", "host", "", "getInternal2", "comparator", "getURIs", "netscapeDomainMatches", "", "domain", "remove", "removeAll", "library_release"})
@SourceDebugExtension(value={"SMAP\nInMemoryCookieStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryCookieStore.kt\nio/appwrite/cookies/stores/InMemoryCookieStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1#2:269\n766#3:270\n857#3,2:271\n*S KotlinDebug\n*F\n+ 1 InMemoryCookieStore.kt\nio/appwrite/cookies/stores/InMemoryCookieStore\n*L\n134#1:270\n134#1:271,2\n*E\n"})
public class InMemoryCookieStore
implements CookieStore {
    @NotNull
    private final Map<URI, List<HttpCookie>> uriIndex = new LinkedHashMap();
    @NotNull
    private final ReentrantLock lock = new ReentrantLock(false);

    @NotNull
    public final Map<URI, List<HttpCookie>> getUriIndex$library_release() {
        return this.uriIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll() {
        boolean bl;
        this.lock.lock();
        try {
            this.uriIndex.clear();
            bl = this.uriIndex.isEmpty();
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@Nullable URI uri, @Nullable HttpCookie cookie) {
        if (cookie == null) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Tried to add null cookie in cookie store. Doing nothing.");
            return;
        }
        if (uri == null) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Tried to add null URI in cookie store. Doing nothing.");
            return;
        }
        this.lock.lock();
        try {
            this.addIndex(this.getEffectiveURI$library_release(uri), cookie);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<HttpCookie> getCookies() {
        List cookies = new ArrayList();
        this.lock.lock();
        try {
            for (List<HttpCookie> list2 : this.uriIndex.values()) {
                Iterator<HttpCookie> it = list2.iterator();
                while (it.hasNext()) {
                    HttpCookie cookie = it.next();
                    if (cookie.hasExpired()) {
                        it.remove();
                        continue;
                    }
                    if (cookies.contains(cookie)) continue;
                    cookies.add(cookie);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<URI> getURIs() {
        List list2;
        List uris = new ArrayList();
        this.lock.lock();
        try {
            list2 = CollectionsKt.toList((Iterable)this.uriIndex.keySet());
        }
        finally {
            uris.addAll((Collection)this.uriIndex.keySet());
            this.lock.unlock();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@Nullable URI uri, @Nullable HttpCookie cookie) {
        boolean bl;
        if (cookie == null) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Tried to remove null cookie from cookie store. Doing nothing.");
            return true;
        }
        if (uri == null) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Tried to remove null URI from cookie store. Doing nothing.");
            return true;
        }
        this.lock.lock();
        try {
            boolean bl2;
            URI lintedURI = this.getEffectiveURI$library_release(uri);
            if (this.uriIndex.get(lintedURI) == null) {
                bl2 = false;
            } else {
                List<HttpCookie> cookies;
                List<HttpCookie> list2 = cookies = this.uriIndex.get(lintedURI);
                bl2 = list2 != null ? list2.remove(cookie) : false;
            }
            bl = bl2;
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<HttpCookie> get(@Nullable URI uri) {
        if (uri == null) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Getting cookies from cookie store for null URI results in empty list");
            return CollectionsKt.emptyList();
        }
        ArrayList cookies = new ArrayList();
        this.lock.lock();
        try {
            void $this$filterTo$iv$iv;
            String string = uri.getHost();
            if (string != null) {
                String it = string;
                boolean bl = false;
                cookies.addAll(this.getInternal1(it));
            }
            Iterable $this$filter$iv = this.getInternal2(this.getEffectiveURI$library_release(uri));
            boolean $i$f$filter = false;
            Iterable bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HttpCookie it = (HttpCookie)element$iv$iv;
                boolean bl2 = false;
                if (!(!cookies.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List internal2 = (List)destination$iv$iv;
            cookies.addAll(internal2);
        }
        finally {
            this.lock.unlock();
        }
        return cookies;
    }

    @NotNull
    public final URI getEffectiveURI$library_release(@NotNull URI uri) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            String string = uri.getScheme();
            if (string == null) {
                string = "http";
            }
            uRI = new URI(string, uri.getHost(), null, null, null);
        }
        catch (URISyntaxException ignored) {
            uRI = uri;
        }
        return uRI;
    }

    private final void addIndex(URI index, HttpCookie cookie) {
        List<HttpCookie> cookies = this.uriIndex.get(index);
        if (cookies != null) {
            cookies.remove(cookie);
            cookies.add(cookie);
        } else {
            List newCookies = new ArrayList();
            newCookies.add(cookie);
            this.uriIndex.put(index, newCookies);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean netscapeDomainMatches(String domain, String host) {
        int firstDotInHost;
        if (domain == null) return false;
        if (host == null) {
            return false;
        }
        boolean isLocalDomain = StringsKt.equals((String)".local", (String)domain, (boolean)true);
        int embeddedDotInDomain = StringsKt.indexOf$default((CharSequence)domain, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (embeddedDotInDomain == 0) {
            embeddedDotInDomain = StringsKt.indexOf$default((CharSequence)domain, (char)'.', (int)1, (boolean)false, (int)4, null);
        }
        if (!isLocalDomain) {
            if (embeddedDotInDomain == -1) return false;
            if (embeddedDotInDomain == domain.length() - 1) {
                return false;
            }
        }
        if ((firstDotInHost = StringsKt.indexOf$default((CharSequence)host, (char)'.', (int)0, (boolean)false, (int)6, null)) == -1 && isLocalDomain) {
            return true;
        }
        int domainLength = domain.length();
        int lengthDiff = host.length() - domainLength;
        if (lengthDiff == 0) {
            return StringsKt.equals((String)host, (String)domain, (boolean)true);
        }
        if (lengthDiff > 0) {
            String string = host.substring(lengthDiff);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String D = string;
            if (Build.VERSION.SDK_INT <= 23 && !StringsKt.startsWith$default((String)domain, (String)".", (boolean)false, (int)2, null)) {
                return false;
            }
            boolean bl = StringsKt.equals((String)D, (String)domain, (boolean)true);
            return bl;
        }
        if (lengthDiff != -1) return false;
        if (domain.charAt(0) != '.') return false;
        String string = domain.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        if (!StringsKt.equals((String)host, (String)string, (boolean)true)) return false;
        return true;
    }

    private final List<HttpCookie> getInternal1(String host) {
        List toRemove = new ArrayList();
        List cookies = new ArrayList();
        Iterator<Map.Entry<URI, List<HttpCookie>>> iterator = this.uriIndex.entrySet().iterator();
        while (iterator.hasNext()) {
            List<HttpCookie> lst = iterator.next().getValue();
            for (HttpCookie c : lst) {
                String domain = c.getDomain();
                if ((c.getVersion() != 0 || !this.netscapeDomainMatches(domain, host)) && (c.getVersion() != 1 || !HttpCookie.domainMatches(domain, host))) continue;
                if (!c.hasExpired()) {
                    if (cookies.contains(c)) continue;
                    cookies.add(c);
                    continue;
                }
                toRemove.add(c);
            }
            for (HttpCookie c : toRemove) {
                lst.remove(c);
            }
            toRemove.clear();
        }
        return cookies;
    }

    private final List<HttpCookie> getInternal2(URI comparator) {
        List cookies = new ArrayList();
        for (URI index : this.uriIndex.keySet()) {
            List<HttpCookie> indexedCookies;
            if (index != comparator && comparator.compareTo(index) != 0 || (indexedCookies = this.uriIndex.get(index)) == null) continue;
            Iterator<HttpCookie> it = indexedCookies.iterator();
            while (it.hasNext()) {
                HttpCookie ck = it.next();
                if (!ck.hasExpired()) {
                    if (cookies.contains(ck)) continue;
                    cookies.add(ck);
                    continue;
                }
                it.remove();
            }
        }
        return cookies;
    }
}

