package arrow.ui.extensions.day.applicative

import arrow.Kind
import arrow.typeclasses.Applicative
import arrow.ui.Day
import arrow.ui.Day.Companion
import arrow.ui.ForDay
import arrow.ui.extensions.DayApplicative
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("just1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A> A.just(AF: Applicative<F>, AG: Applicative<G>): Day<F, G, A> =
    arrow.ui.Day.applicative<F, G>(AF, AG).run {
  this@just.just<A>() as arrow.ui.Day<F, G, A>
}

@JvmName("unit")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G> unit(AF: Applicative<F>, AG: Applicative<G>): Day<F, G, Unit> = arrow.ui.Day
   .applicative<F, G>(AF, AG)
   .unit() as arrow.ui.Day<F, G, kotlin.Unit>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForDay, F>, G>, A>.map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Function1<A, B>
): Day<F, G, B> = arrow.ui.Day.applicative<F, G>(AF, AG).run {
  this@map.map<A, B>(arg1) as arrow.ui.Day<F, G, B>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, G> Companion.applicative(AF: Applicative<F>, AG: Applicative<G>): DayApplicative<F,
    G> = object : arrow.ui.extensions.DayApplicative<F, G> { override fun AF():
    arrow.typeclasses.Applicative<F> = AF

  override fun AG(): arrow.typeclasses.Applicative<G> = AG }