package arrow.ui.extensions.day.apply

import arrow.Kind
import arrow.core.Eval
import arrow.core.Tuple10
import arrow.core.Tuple2
import arrow.core.Tuple3
import arrow.core.Tuple4
import arrow.core.Tuple5
import arrow.core.Tuple6
import arrow.core.Tuple7
import arrow.core.Tuple8
import arrow.core.Tuple9
import arrow.typeclasses.Applicative
import arrow.ui.Day
import arrow.ui.Day.Companion
import arrow.ui.ForDay
import arrow.ui.extensions.DayApply
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("ap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForDay, F>, G>, A>.ap(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Function1<A, B>>
): Day<F, G, B> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@ap.ap<A, B>(arg1) as arrow.ui.Day<F, G, B>
}

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Function1<Tuple2<A, B>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, Z>(arg0, arg1, arg2) as arrow.ui.Day<F, G, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Function1<Tuple3<A, B, C>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, C, Z>(arg0, arg1, arg2, arg3) as arrow.ui.Day<F, G, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Function1<Tuple4<A, B, C, D>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, C, D, Z>(arg0, arg1, arg2, arg3, arg4) as arrow.ui.Day<F, G, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Function1<Tuple5<A, B, C, D, E>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, C, D, E, Z>(arg0, arg1, arg2, arg3, arg4, arg5) as arrow.ui.Day<F, G, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Function1<Tuple6<A, B, C, D, E, FF>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, C, D, E, FF, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6) as arrow.ui.Day<F, G, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Kind<Kind<Kind<ForDay, F>, G>, G>,
  arg7: Function1<Tuple7<A, B, C, D, E, FF, G>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, C, D, E, FF, G, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7) as arrow.ui.Day<F,
    G, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, H, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Kind<Kind<Kind<ForDay, F>, G>, G>,
  arg7: Kind<Kind<Kind<ForDay, F>, G>, H>,
  arg8: Function1<Tuple8<A, B, C, D, E, FF, G, H>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, C, D, E, FF, G, H, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) as
    arrow.ui.Day<F, G, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, H, I, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Kind<Kind<Kind<ForDay, F>, G>, G>,
  arg7: Kind<Kind<Kind<ForDay, F>, G>, H>,
  arg8: Kind<Kind<Kind<ForDay, F>, G>, I>,
  arg9: Function1<Tuple9<A, B, C, D, E, FF, G, H, I>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, C, D, E, FF, G, H, I, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9)
    as arrow.ui.Day<F, G, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, H, I, J, Z> map(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Kind<Kind<Kind<ForDay, F>, G>, G>,
  arg7: Kind<Kind<Kind<ForDay, F>, G>, H>,
  arg8: Kind<Kind<Kind<ForDay, F>, G>, I>,
  arg9: Kind<Kind<Kind<ForDay, F>, G>, J>,
  arg10: Function1<Tuple10<A, B, C, D, E, FF, G, H, I, J>, Z>
): Day<F, G, Z> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .map<A, B, C, D, E, FF, G, H, I, J,
    Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) as arrow.ui.Day<F, G, Z>

@JvmName("map2")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, Z> Kind<Kind<Kind<ForDay, F>, G>, A>.map2(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Function1<Tuple2<A, B>, Z>
): Day<F, G, Z> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@map2.map2<A, B, Z>(arg1, arg2) as arrow.ui.Day<F, G, Z>
}

@JvmName("map2Eval")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, Z> Kind<Kind<Kind<ForDay, F>, G>, A>.map2Eval(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Eval<Kind<Kind<Kind<ForDay, F>, G>, B>>,
  arg2: Function1<Tuple2<A, B>, Z>
): Eval<Kind<Kind<Kind<ForDay, F>, G>, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@map2Eval.map2Eval<A, B, Z>(arg1, arg2) as
    arrow.core.Eval<arrow.Kind<arrow.Kind<arrow.Kind<arrow.ui.ForDay, F>, G>, Z>>
}

@JvmName("product")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForDay, F>, G>, A>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>
): Day<F, G, Tuple2<A, B>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B>(arg1) as arrow.ui.Day<F, G, arrow.core.Tuple2<A, B>>
}

@JvmName("product1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, Z> Kind<Kind<Kind<ForDay, F>, G>, Tuple2<A, B>>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Z>
): Day<F, G, Tuple3<A, B, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B, Z>(arg1) as arrow.ui.Day<F, G, arrow.core.Tuple3<A, B, Z>>
}

@JvmName("product2")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, Z> Kind<Kind<Kind<ForDay, F>, G>, Tuple3<A, B, C>>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Z>
): Day<F, G, Tuple4<A, B, C, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B, C, Z>(arg1) as arrow.ui.Day<F, G, arrow.core.Tuple4<A, B, C, Z>>
}

@JvmName("product3")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, Z> Kind<Kind<Kind<ForDay, F>, G>, Tuple4<A, B, C, D>>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Z>
): Day<F, G, Tuple5<A, B, C, D, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B, C, D, Z>(arg1) as arrow.ui.Day<F, G, arrow.core.Tuple5<A, B, C, D, Z>>
}

@JvmName("product4")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, Z> Kind<Kind<Kind<ForDay, F>, G>, Tuple5<A, B, C, D, E>>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Z>
): Day<F, G, Tuple6<A, B, C, D, E, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B, C, D, E, Z>(arg1) as arrow.ui.Day<F, G, arrow.core.Tuple6<A, B, C, D,
    E, Z>>
}

@JvmName("product5")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, Z> Kind<Kind<Kind<ForDay, F>, G>, Tuple6<A, B, C, D, E, FF>>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Z>
): Day<F, G, Tuple7<A, B, C, D, E, FF, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B, C, D, E, FF, Z>(arg1) as arrow.ui.Day<F, G, arrow.core.Tuple7<A, B, C,
    D, E, FF, Z>>
}

@JvmName("product6")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, Z> Kind<Kind<Kind<ForDay, F>, G>, Tuple7<A, B, C, D, E, FF,
    G>>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Z>
): Day<F, G, Tuple8<A, B, C, D, E, FF, G, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B, C, D, E, FF, G, Z>(arg1) as arrow.ui.Day<F, G, arrow.core.Tuple8<A, B,
    C, D, E, FF, G, Z>>
}

@JvmName("product7")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, H, Z> Kind<Kind<Kind<ForDay, F>, G>, Tuple8<A, B, C, D, E, FF, G,
    H>>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Z>
): Day<F, G, Tuple9<A, B, C, D, E, FF, G, H, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B, C, D, E, FF, G, H, Z>(arg1) as arrow.ui.Day<F, G, arrow.core.Tuple9<A,
    B, C, D, E, FF, G, H, Z>>
}

@JvmName("product8")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, H, I, Z> Kind<Kind<Kind<ForDay, F>, G>, Tuple9<A, B, C, D, E, FF, G,
    H, I>>.product(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, Z>
): Day<F, G, Tuple10<A, B, C, D, E, FF, G, H, I, Z>> = arrow.ui.Day.apply<F, G>(AF, AG).run {
  this@product.product<A, B, C, D, E, FF, G, H, I, Z>(arg1) as arrow.ui.Day<F, G,
    arrow.core.Tuple10<A, B, C, D, E, FF, G, H, I, Z>>
}

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>
): Day<F, G, Tuple2<A, B>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B>(arg0, arg1) as arrow.ui.Day<F, G, arrow.core.Tuple2<A, B>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>
): Day<F, G, Tuple3<A, B, C>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B, C>(arg0, arg1, arg2) as arrow.ui.Day<F, G, arrow.core.Tuple3<A, B, C>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>
): Day<F, G, Tuple4<A, B, C, D>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B, C, D>(arg0, arg1, arg2, arg3) as arrow.ui.Day<F, G, arrow.core.Tuple4<A, B, C, D>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>
): Day<F, G, Tuple5<A, B, C, D, E>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B, C, D, E>(arg0, arg1, arg2, arg3, arg4) as arrow.ui.Day<F, G, arrow.core.Tuple5<A,
    B, C, D, E>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>
): Day<F, G, Tuple6<A, B, C, D, E, FF>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B, C, D, E, FF>(arg0, arg1, arg2, arg3, arg4, arg5) as arrow.ui.Day<F, G,
    arrow.core.Tuple6<A, B, C, D, E, FF>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Kind<Kind<Kind<ForDay, F>, G>, G>
): Day<F, G, Tuple7<A, B, C, D, E, FF, G>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B, C, D, E, FF, G>(arg0, arg1, arg2, arg3, arg4, arg5, arg6) as arrow.ui.Day<F, G,
    arrow.core.Tuple7<A, B, C, D, E, FF, G>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, H> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Kind<Kind<Kind<ForDay, F>, G>, G>,
  arg7: Kind<Kind<Kind<ForDay, F>, G>, H>
): Day<F, G, Tuple8<A, B, C, D, E, FF, G, H>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B, C, D, E, FF, G, H>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7) as
    arrow.ui.Day<F, G, arrow.core.Tuple8<A, B, C, D, E, FF, G, H>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, H, I> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Kind<Kind<Kind<ForDay, F>, G>, G>,
  arg7: Kind<Kind<Kind<ForDay, F>, G>, H>,
  arg8: Kind<Kind<Kind<ForDay, F>, G>, I>
): Day<F, G, Tuple9<A, B, C, D, E, FF, G, H, I>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B, C, D, E, FF, G, H, I>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) as
    arrow.ui.Day<F, G, arrow.core.Tuple9<A, B, C, D, E, FF, G, H, I>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B, C, D, E, FF, H, I, J> tupled(
  AF: Applicative<F>,
  AG: Applicative<G>,
  arg0: Kind<Kind<Kind<ForDay, F>, G>, A>,
  arg1: Kind<Kind<Kind<ForDay, F>, G>, B>,
  arg2: Kind<Kind<Kind<ForDay, F>, G>, C>,
  arg3: Kind<Kind<Kind<ForDay, F>, G>, D>,
  arg4: Kind<Kind<Kind<ForDay, F>, G>, E>,
  arg5: Kind<Kind<Kind<ForDay, F>, G>, FF>,
  arg6: Kind<Kind<Kind<ForDay, F>, G>, G>,
  arg7: Kind<Kind<Kind<ForDay, F>, G>, H>,
  arg8: Kind<Kind<Kind<ForDay, F>, G>, I>,
  arg9: Kind<Kind<Kind<ForDay, F>, G>, J>
): Day<F, G, Tuple10<A, B, C, D, E, FF, G, H, I, J>> = arrow.ui.Day
   .apply<F, G>(AF, AG)
   .tupled<A, B, C, D, E, FF, G, H, I,
    J>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) as arrow.ui.Day<F, G,
    arrow.core.Tuple10<A, B, C, D, E, FF, G, H, I, J>>

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, G> Companion.apply(AF: Applicative<F>, AG: Applicative<G>): DayApply<F, G> = object :
    arrow.ui.extensions.DayApply<F, G> { override fun AF(): arrow.typeclasses.Applicative<F> = AF

  override fun AG(): arrow.typeclasses.Applicative<G> = AG }