package arrow.ui.extensions.moore.functor

import arrow.Kind
import arrow.core.Tuple2
import arrow.ui.ForMoore
import arrow.ui.Moore
import arrow.ui.Moore.Companion
import arrow.ui.extensions.MooreFunctor
import kotlin.Function1
import kotlin.PublishedApi
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * cached extension
 */
@PublishedApi()
internal val functor_singleton: MooreFunctor<Any?> = object : MooreFunctor<Any?> {}

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.map(arg1: Function1<A, B>): Moore<V, B> =
    arrow.ui.Moore.functor<V>().run {
  this@map.map<A, B>(arg1) as arrow.ui.Moore<V, B>
}

@JvmName("imap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.imap(arg1: Function1<A, B>, arg2: Function1<B, A>):
    Moore<V, B> = arrow.ui.Moore.functor<V>().run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.ui.Moore<V, B>
}

@JvmName("lift")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, A, B> lift(arg0: Function1<A, B>): Function1<Kind<Kind<ForMoore, V>, A>, Kind<Kind<ForMoore,
    V>, B>> = arrow.ui.Moore
   .functor<V>()
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.ui.ForMoore, V>, A>,
    arrow.Kind<arrow.Kind<arrow.ui.ForMoore, V>, B>>

@JvmName("unit")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, A> Kind<Kind<ForMoore, V>, A>.unit(): Moore<V, Unit> = arrow.ui.Moore.functor<V>().run {
  this@unit.unit<A>() as arrow.ui.Moore<V, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.fproduct(arg1: Function1<A, B>): Moore<V, Tuple2<A, B>> =
    arrow.ui.Moore.functor<V>().run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.ui.Moore<V, arrow.core.Tuple2<A, B>>
}

@JvmName("as")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.`as`(arg1: B): Moore<V, B> =
    arrow.ui.Moore.functor<V>().run {
  this@`as`.`as`<A, B>(arg1) as arrow.ui.Moore<V, B>
}

@JvmName("tupleLeft")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.tupleLeft(arg1: B): Moore<V, Tuple2<B, A>> =
    arrow.ui.Moore.functor<V>().run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.ui.Moore<V, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.tupleRight(arg1: B): Moore<V, Tuple2<A, B>> =
    arrow.ui.Moore.functor<V>().run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.ui.Moore<V, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <V, B, A : B> Kind<Kind<ForMoore, V>, A>.widen(): Moore<V, B> =
    arrow.ui.Moore.functor<V>().run {
  this@widen.widen<B, A>() as arrow.ui.Moore<V, B>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <V> Companion.functor(): MooreFunctor<V> = functor_singleton as
    arrow.ui.extensions.MooreFunctor<V>