package arrow.ui.extensions.sum.comonad

import arrow.Kind
import arrow.typeclasses.Comonad
import arrow.ui.ForSum
import arrow.ui.Sum
import arrow.ui.Sum.Companion
import arrow.ui.extensions.SumComonad
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("coflatMap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.coflatMap(
  CF: Comonad<F>,
  CG: Comonad<G>,
  arg1: Function1<Kind<Kind<Kind<ForSum, F>, G>, A>, B>
): Sum<F, G, B> = arrow.ui.Sum.comonad<F, G>(CF, CG).run {
  this@coflatMap.coflatMap<A, B>(arg1) as arrow.ui.Sum<F, G, B>
}

@JvmName("extract")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForSum, F>, G>, A>.extract(CF: Comonad<F>, CG: Comonad<G>): A =
    arrow.ui.Sum.comonad<F, G>(CF, CG).run {
  this@extract.extract<A>() as A
}

@JvmName("duplicate")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForSum, F>, G>, A>.duplicate(CF: Comonad<F>, CG: Comonad<G>): Sum<F, G,
    Sum<F, G, A>> = arrow.ui.Sum.comonad<F, G>(CF, CG).run {
  this@duplicate.duplicate<A>() as arrow.ui.Sum<F, G, arrow.ui.Sum<F, G, A>>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, G> Companion.comonad(CF: Comonad<F>, CG: Comonad<G>): SumComonad<F, G> = object :
    arrow.ui.extensions.SumComonad<F, G> { override fun CF(): arrow.typeclasses.Comonad<F> = CF

  override fun CG(): arrow.typeclasses.Comonad<G> = CG }