/*
 * Decompiled with CFR 0.152.
 */
package io.circe.jackson;

import cats.data.NonEmptyList;
import cats.data.Validated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.circe.Decoder;
import io.circe.Error;
import io.circe.Json;
import io.circe.Parser;
import io.circe.ParsingFailure;
import io.circe.jackson.JacksonCompat;
import io.circe.jackson.JacksonCompat$class;
import io.circe.jackson.JacksonParser;
import io.circe.jackson.JacksonParser$class;
import io.circe.jackson.WithJacksonMapper;
import io.circe.jackson.package;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import scala.util.Either;

public final class package$
extends WithJacksonMapper
implements JacksonParser,
JacksonCompat {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    @Override
    public ObjectWriter makeWriter(ObjectMapper mapper) {
        return JacksonCompat$class.makeWriter(this, mapper);
    }

    @Override
    public void handleUnexpectedToken(DeserializationContext context, Class<?> klass, JsonParser parser) {
        JacksonCompat$class.handleUnexpectedToken(this, context, klass, parser);
    }

    @Override
    public final Either<ParsingFailure, Json> parse(String input) {
        return JacksonParser$class.parse(this, input);
    }

    @Override
    public final Either<ParsingFailure, Json> parseFile(File file) {
        return JacksonParser$class.parseFile(this, file);
    }

    @Override
    public final Either<ParsingFailure, Json> parseByteArray(byte[] bytes) {
        return JacksonParser$class.parseByteArray(this, bytes);
    }

    @Override
    public final <A> Either<Error, A> decodeByteArray(byte[] bytes, Decoder<A> evidence$1) {
        return JacksonParser$class.decodeByteArray(this, bytes, evidence$1);
    }

    @Override
    public final <A> Validated<NonEmptyList<Error>, A> decodeByteArrayAccumulating(byte[] bytes, Decoder<A> evidence$2) {
        return JacksonParser$class.decodeByteArrayAccumulating(this, bytes, evidence$2);
    }

    @Override
    public final <A> Either<Error, A> decodeFile(File file, Decoder<A> evidence$3) {
        return JacksonParser$class.decodeFile(this, file, evidence$3);
    }

    @Override
    public final <A> Validated<NonEmptyList<Error>, A> decodeFileAccumulating(File file, Decoder<A> evidence$4) {
        return JacksonParser$class.decodeFileAccumulating(this, file, evidence$4);
    }

    public final <A> Either<Error, A> finishDecode(Either<ParsingFailure, Json> input, Decoder<A> decoder) {
        return Parser.class.finishDecode((Parser)this, input, decoder);
    }

    public final <A> Validated<NonEmptyList<Error>, A> finishDecodeAccumulating(Either<ParsingFailure, Json> input, Decoder<A> decoder) {
        return Parser.class.finishDecodeAccumulating((Parser)this, input, decoder);
    }

    public final <A> Either<Error, A> decode(String input, Decoder<A> evidence$1) {
        return Parser.class.decode((Parser)this, (String)input, evidence$1);
    }

    public final <A> Validated<NonEmptyList<Error>, A> decodeAccumulating(String input, Decoder<A> evidence$2) {
        return Parser.class.decodeAccumulating((Parser)this, (String)input, evidence$2);
    }

    private void writeJson(Writer w, Json j) {
        JsonGenerator gen = this.jsonGenerator(w);
        this.makeWriter(this.mapper()).writeValue(gen, (Object)j);
        w.flush();
    }

    public final String jacksonPrint(Json json) {
        StringWriter sw = new StringWriter();
        this.writeJson(sw, json);
        return sw.toString();
    }

    public final ByteBuffer jacksonPrintByteBuffer(Json json) {
        package.EnhancedByteArrayOutputStream bytes = new package.EnhancedByteArrayOutputStream();
        this.writeJson(new BufferedWriter(new OutputStreamWriter((OutputStream)bytes, "UTF-8")), json);
        return bytes.toByteBuffer();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private package$() {
        MODULE$ = this;
        Parser.class.$init$((Parser)this);
        JacksonParser$class.$init$(this);
        JacksonCompat$class.$init$(this);
    }
}

