/*
 * Decompiled with CFR 0.152.
 */
package coil.bitmappool;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.Px;
import androidx.collection.ArraySet;
import androidx.collection.ArraySetKt;
import coil.bitmappool.BitmapPool;
import coil.bitmappool.strategy.BitmapPoolStrategy;
import coil.util.ExtensionsKt;
import coil.util.Logger;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0006\u0010\u0016\u001a\u00020\u0013J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J$\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u000e2\b\b\u0001\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J$\u0010\u001e\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u000e2\b\b\u0001\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J&\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u000e2\b\b\u0001\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J&\u0010 \u001a\u0004\u0018\u00010\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u000e2\b\b\u0001\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u000eH\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcoil/bitmappool/RealBitmapPool;", "Lcoil/bitmappool/BitmapPool;", "maxSize", "", "allowedConfigs", "", "Landroid/graphics/Bitmap$Config;", "strategy", "Lcoil/bitmappool/strategy/BitmapPoolStrategy;", "logger", "Lcoil/util/Logger;", "(JLjava/util/Set;Lcoil/bitmappool/strategy/BitmapPoolStrategy;Lcoil/util/Logger;)V", "currentSize", "evictions", "", "hits", "misses", "puts", "assertNotHardwareConfig", "", "config", "clear", "clearMemory", "computeUnchecked", "", "dump", "get", "Landroid/graphics/Bitmap;", "width", "height", "getDirty", "getDirtyOrNull", "getOrNull", "normalize", "bitmap", "put", "trimMemory", "level", "trimToSize", "size", "Companion", "coil-base_release"})
public final class RealBitmapPool
implements BitmapPool {
    private long currentSize;
    private int hits;
    private int misses;
    private int puts;
    private int evictions;
    private final long maxSize;
    private final Set<Bitmap.Config> allowedConfigs;
    private final BitmapPoolStrategy strategy;
    private final Logger logger;
    private static final String TAG = "RealBitmapPool";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void put(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        boolean bl = !bitmap.isRecycled();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot pool recycled bitmap!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int size2 = ExtensionsKt.getAllocationByteCountCompat(bitmap);
        if (!bitmap.isMutable() || (long)size2 > this.maxSize || !this.allowedConfigs.contains(bitmap.getConfig())) {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv2;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 2;
                boolean $i$f$log = false;
                if ($this$log$iv2.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var9_17 = tag$iv;
                    void var8_19 = $this$log$iv2;
                    boolean bl5 = false;
                    String string2 = "Rejected bitmap from pool: bitmap: " + this.strategy.logBitmap(bitmap) + ", " + "is mutable: " + bitmap.isMutable() + ", " + "is greater than max size: " + ((long)size2 > this.maxSize) + "is allowed config: " + this.allowedConfigs.contains(bitmap.getConfig());
                    var8_19.log((String)var9_17, n, string2, null);
                }
            }
            bitmap.recycle();
            return;
        }
        this.strategy.put(bitmap);
        int $this$log$iv2 = this.puts;
        this.puts = $this$log$iv2 + 1;
        this.currentSize += (long)size2;
        Logger logger = this.logger;
        if (logger != null) {
            Logger $this$log$iv2 = logger;
            String tag$iv = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv2.getLevel() <= priority$iv) {
                int n = priority$iv;
                String string = tag$iv;
                Logger logger3 = $this$log$iv2;
                boolean bl6 = false;
                String string3 = "Put bitmap in pool=" + this.strategy.logBitmap(bitmap);
                logger3.log(string, n, string3, null);
            }
        }
        this.dump();
        this.trimToSize(this.maxSize);
    }

    @Override
    @NotNull
    public Bitmap get(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Bitmap result = this.getOrNull(width, height, config);
        Bitmap bitmap = result;
        if (bitmap == null) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bitmap = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(width, height, config)");
        }
        return bitmap;
    }

    @Override
    @Nullable
    public Bitmap getOrNull(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Bitmap result;
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            Bitmap bitmap = result = this.getDirtyOrNull(width, height, config);
            if (bitmap == null) break block0;
            bitmap.eraseColor(0);
        }
        return result;
    }

    @Override
    @NotNull
    public Bitmap getDirty(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Bitmap result = this.getDirtyOrNull(width, height, config);
        Bitmap bitmap = result;
        if (bitmap == null) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bitmap = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(width, height, config)");
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public synchronized Bitmap getDirtyOrNull(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        int $this$log$iv2;
        String string;
        Logger logger;
        String string2;
        String tag$iv;
        int n;
        boolean $i$f$log;
        int priority$iv;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.assertNotHardwareConfig(config);
        Bitmap result = this.strategy.get(width, height, config);
        if (result == null) {
            Logger logger2 = this.logger;
            if (logger2 != null) {
                void $this$log$iv2;
                Logger logger3 = logger2;
                String string3 = TAG;
                priority$iv = 2;
                $i$f$log = false;
                if ($this$log$iv2.getLevel() <= priority$iv) {
                    n = priority$iv;
                    string2 = tag$iv;
                    logger = $this$log$iv2;
                    boolean bl = false;
                    string = "Missing bitmap=" + this.strategy.logBitmap(width, height, config);
                    logger.log(string2, n, string, null);
                }
            }
            $this$log$iv2 = this.misses;
            this.misses = $this$log$iv2 + 1;
        } else {
            $this$log$iv2 = this.hits;
            this.hits = $this$log$iv2 + 1;
            this.currentSize -= (long)ExtensionsKt.getAllocationByteCountCompat(result);
            this.normalize(result);
        }
        Logger logger4 = this.logger;
        if (logger4 != null) {
            Logger $this$log$iv2 = logger4;
            tag$iv = TAG;
            priority$iv = 2;
            $i$f$log = false;
            if ($this$log$iv2.getLevel() <= priority$iv) {
                n = priority$iv;
                string2 = tag$iv;
                logger = $this$log$iv2;
                boolean bl = false;
                string = "Get bitmap=" + this.strategy.logBitmap(width, height, config);
                logger.log(string2, n, string, null);
            }
        }
        this.dump();
        return result;
    }

    @Override
    public void clear() {
        this.clearMemory();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearMemory() {
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var7_6 = tag$iv;
                void var6_7 = $this$log$iv;
                boolean bl = false;
                String string2 = "clearMemory";
                var6_7.log((String)var7_6, n, string2, null);
            }
        }
        this.trimToSize(-1L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void trimMemory(int level) {
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var8_8 = tag$iv;
                void var7_9 = $this$log$iv;
                boolean bl = false;
                String string2 = "trimMemory, level=" + level;
                var7_9.log((String)var8_8, n, string2, null);
            }
        }
        if (level >= 40) {
            this.clearMemory();
        } else {
            int n = level;
            if (10 <= n && 20 > n) {
                this.trimToSize(this.currentSize / (long)2);
            }
        }
    }

    private final void normalize(Bitmap bitmap) {
        bitmap.setDensity(0);
        bitmap.setHasAlpha(true);
        if (Build.VERSION.SDK_INT >= 19) {
            bitmap.setPremultiplied(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void trimToSize(long size2) {
        while (this.currentSize > size2) {
            String string;
            Logger logger;
            String string2;
            String tag$iv;
            int n;
            boolean $i$f$log;
            int priority$iv;
            Bitmap removed = this.strategy.removeLast();
            if (removed == null) {
                Logger logger2 = this.logger;
                if (logger2 != null) {
                    void $this$log$iv;
                    Logger logger3 = logger2;
                    String string3 = TAG;
                    priority$iv = 5;
                    $i$f$log = false;
                    if ($this$log$iv.getLevel() <= priority$iv) {
                        n = priority$iv;
                        string2 = tag$iv;
                        logger = $this$log$iv;
                        boolean bl = false;
                        string = "Size mismatch, resetting.\n" + this.computeUnchecked();
                        logger.log(string2, n, string, null);
                    }
                }
                this.currentSize = 0L;
                return;
            }
            this.currentSize -= (long)ExtensionsKt.getAllocationByteCountCompat(removed);
            int $this$log$iv = this.evictions;
            this.evictions = $this$log$iv + 1;
            if (this.logger != null) {
                tag$iv = TAG;
                priority$iv = 2;
                $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    n = priority$iv;
                    string2 = tag$iv;
                    logger = $this$log$iv;
                    boolean bl = false;
                    string = "Evicting bitmap=" + this.strategy.logBitmap(removed);
                    logger.log(string2, n, string, null);
                }
            }
            this.dump();
            removed.recycle();
        }
    }

    private final void assertNotHardwareConfig(Bitmap.Config config) {
        boolean bl = Build.VERSION.SDK_INT < 26 || config != Bitmap.Config.HARDWARE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot create a mutable hardware Bitmap.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dump() {
        block1: {
            void $this$log$iv;
            Logger logger = this.logger;
            if (logger == null) break block1;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var7_6 = tag$iv;
                void var6_7 = $this$log$iv;
                boolean bl = false;
                String string2 = this.computeUnchecked();
                var6_7.log((String)var7_6, n, string2, null);
            }
        }
    }

    private final String computeUnchecked() {
        return "Hits=" + this.hits + ", misses=" + this.misses + ", puts=" + this.puts + ", evictions=" + this.evictions + ", " + "currentSize=" + this.currentSize + ", maxSize=" + this.maxSize + ", strategy=" + this.strategy;
    }

    public RealBitmapPool(long maxSize, @NotNull Set<? extends Bitmap.Config> allowedConfigs, @NotNull BitmapPoolStrategy strategy, @Nullable Logger logger) {
        Intrinsics.checkParameterIsNotNull(allowedConfigs, (String)"allowedConfigs");
        Intrinsics.checkParameterIsNotNull((Object)strategy, (String)"strategy");
        this.maxSize = maxSize;
        this.allowedConfigs = allowedConfigs;
        this.strategy = strategy;
        this.logger = logger;
        boolean bl = this.maxSize >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxSize must be >= 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RealBitmapPool(long l, Set set, BitmapPoolStrategy bitmapPoolStrategy, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = RealBitmapPool.Companion.getDefaultAllowedConfigs();
        }
        if ((n & 4) != 0) {
            bitmapPoolStrategy = BitmapPoolStrategy.Companion.invoke();
        }
        if ((n & 8) != 0) {
            logger = null;
        }
        this(l, set, bitmapPoolStrategy, logger);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/bitmappool/RealBitmapPool$Companion;", "", "()V", "TAG", "", "getDefaultAllowedConfigs", "", "Landroid/graphics/Bitmap$Config;", "coil-base_release"})
    public static final class Companion {
        private final Set<Bitmap.Config> getDefaultAllowedConfigs() {
            ArraySet configs = ArraySetKt.arraySetOf((Object[])new Bitmap.Config[]{Bitmap.Config.ALPHA_8, Bitmap.Config.RGB_565, Bitmap.Config.ARGB_4444, Bitmap.Config.ARGB_8888});
            if (Build.VERSION.SDK_INT >= 26) {
                Collection collection = (Collection)configs;
                Bitmap.Config config = Bitmap.Config.RGBA_F16;
                boolean bl = false;
                collection.add(config);
            }
            return (Set)configs;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

