/*
 * Decompiled with CFR 0.152.
 */
package coil.bitmappool.strategy;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import coil.bitmappool.strategy.BitmapPoolStrategy;
import coil.collection.GroupedLinkedMap;
import coil.util.ExtensionsKt;
import coil.util.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0001\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0002J&\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0013\u001a\u00020\u000b2\b\b\u0001\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J$\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0013\u001a\u00020\u000b2\b\b\u0001\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcoil/bitmappool/strategy/SizeConfigStrategy;", "Lcoil/bitmappool/strategy/BitmapPoolStrategy;", "()V", "groupedMap", "Lcoil/collection/GroupedLinkedMap;", "Lcoil/bitmappool/strategy/SizeConfigStrategy$Key;", "Landroid/graphics/Bitmap;", "sortedSizes", "Ljava/util/HashMap;", "Landroid/graphics/Bitmap$Config;", "Ljava/util/NavigableMap;", "", "decrementBitmapOfSize", "", "size", "removed", "findBestKey", "config", "get", "width", "height", "getInConfigs", "", "requested", "(Landroid/graphics/Bitmap$Config;)[Landroid/graphics/Bitmap$Config;", "getSizesForConfig", "logBitmap", "", "bitmap", "put", "removeLast", "toString", "Companion", "Key", "coil-base_release"})
@RequiresApi(value=19)
public final class SizeConfigStrategy
implements BitmapPoolStrategy {
    private final GroupedLinkedMap<Key, Bitmap> groupedMap = new GroupedLinkedMap();
    private final HashMap<Bitmap.Config, NavigableMap<Integer, Integer>> sortedSizes = new HashMap();
    private static final int MAX_SIZE_MULTIPLE = 8;
    private static final Bitmap.Config[] ARGB_8888_IN_CONFIGS;
    private static final Bitmap.Config[] RGBA_F16_IN_CONFIGS;
    private static final Bitmap.Config[] RGB_565_IN_CONFIGS;
    private static final Bitmap.Config[] ARGB_4444_IN_CONFIGS;
    private static final Bitmap.Config[] ALPHA_8_IN_CONFIGS;
    public static final Companion Companion;

    @Override
    public void put(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int n = ExtensionsKt.getAllocationByteCountCompat(bitmap);
        Bitmap.Config config = bitmap.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"bitmap.config");
        Key key = new Key(n, config);
        this.groupedMap.set(key, bitmap);
        NavigableMap<Integer, Integer> sizes = this.getSizesForConfig(bitmap.getConfig());
        Integer current = (Integer)sizes.get(key.getSize());
        ((Map)sizes).put(key.getSize(), current == null ? 1 : current + 1);
    }

    @Override
    @Nullable
    public Bitmap get(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        int size2 = Utils.INSTANCE.calculateAllocationByteCount(width, height, config);
        Key bestKey = this.findBestKey(size2, config);
        Bitmap result = this.groupedMap.get(bestKey);
        if (result != null) {
            this.decrementBitmapOfSize(bestKey.getSize(), result);
            result.reconfigure(width, height, config);
        }
        return result;
    }

    private final Key findBestKey(int size2, Bitmap.Config config) {
        for (Bitmap.Config possibleConfig : this.getInConfigs(config)) {
            Integer possibleSize = this.getSizesForConfig(possibleConfig).ceilingKey(size2);
            if (possibleSize == null || possibleSize > size2 * 8) continue;
            return new Key(possibleSize, possibleConfig);
        }
        return new Key(size2, config);
    }

    @Override
    @Nullable
    public Bitmap removeLast() {
        Bitmap removed = this.groupedMap.removeLast();
        if (removed != null) {
            this.decrementBitmapOfSize(ExtensionsKt.getAllocationByteCountCompat(removed), removed);
        }
        return removed;
    }

    private final void decrementBitmapOfSize(int size2, Bitmap removed) {
        Bitmap.Config config = removed.getConfig();
        NavigableMap<Integer, Integer> sizes = this.getSizesForConfig(config);
        Object v = sizes.get(size2);
        boolean bl = false;
        boolean bl2 = false;
        if (v == null) {
            boolean bl3 = false;
            String string = "Tried to decrement empty size, size: " + size2 + ", removed: " + this.logBitmap(removed) + ", this: " + this;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int current = ((Number)v).intValue();
        if (current == 1) {
            sizes.remove(size2);
        } else {
            ((Map)sizes).put(size2, current - 1);
        }
    }

    private final NavigableMap<Integer, Integer> getSizesForConfig(Bitmap.Config config) {
        Object object;
        Map $this$getOrPut$iv = this.sortedSizes;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(config);
        if (value$iv == null) {
            boolean bl = false;
            TreeMap answer$iv = new TreeMap();
            $this$getOrPut$iv.put(config, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (NavigableMap)object;
    }

    private final Bitmap.Config[] getInConfigs(Bitmap.Config requested) {
        Bitmap.Config[] configArray;
        if (Build.VERSION.SDK_INT >= 26 && Bitmap.Config.RGBA_F16 == requested) {
            configArray = RGBA_F16_IN_CONFIGS;
        } else if (requested == Bitmap.Config.ARGB_8888) {
            configArray = ARGB_8888_IN_CONFIGS;
        } else if (requested == Bitmap.Config.RGB_565) {
            configArray = RGB_565_IN_CONFIGS;
        } else if (requested == Bitmap.Config.ARGB_4444) {
            configArray = ARGB_4444_IN_CONFIGS;
        } else if (requested == Bitmap.Config.ALPHA_8) {
            configArray = ALPHA_8_IN_CONFIGS;
        } else {
            Bitmap.Config[] configArray2 = new Bitmap.Config[1];
            configArray = configArray2;
            configArray2[0] = requested;
        }
        return configArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String logBitmap(@NotNull Bitmap bitmap) {
        void size$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Companion companion = Companion;
        int n = ExtensionsKt.getAllocationByteCountCompat(bitmap);
        Bitmap.Config config = bitmap.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"bitmap.config");
        Bitmap.Config config$iv = config;
        boolean $i$f$getBitmapString = false;
        return "" + '[' + (int)size$iv + "](" + config$iv + ')';
    }

    @Override
    @NotNull
    public String logBitmap(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        int size2 = Utils.INSTANCE.calculateAllocationByteCount(width, height, config);
        Companion this_$iv = Companion;
        boolean $i$f$getBitmapString = false;
        return "" + '[' + size2 + "](" + config + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("SizeConfigStrategy: groupedMap=");
        $this$buildString.append(this.groupedMap);
        $this$buildString.append(", sortedSizes=(");
        Map $this$forEach$iv = this.sortedSizes;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl5 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry element$iv;
            Map.Entry $dstr$key$value = element$iv = iterator.next();
            boolean bl6 = false;
            Map.Entry entry = $dstr$key$value;
            boolean bl7 = false;
            Bitmap.Config config = (Bitmap.Config)entry.getKey();
            entry = $dstr$key$value;
            bl7 = false;
            NavigableMap value = (NavigableMap)entry.getValue();
            $this$buildString.append(key);
            $this$buildString.append("[");
            $this$buildString.append(value);
            $this$buildString.append("], ");
        }
        Map map2 = this.sortedSizes;
        boolean bl8 = false;
        if (!map2.isEmpty()) {
            $this$buildString.replace($this$buildString.length() - 2, $this$buildString.length(), "");
        }
        $this$buildString.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    static {
        Bitmap.Config[] configArray;
        Companion = new Companion(null);
        if (Build.VERSION.SDK_INT >= 26) {
            Bitmap.Config[] configArray2 = new Bitmap.Config[2];
            configArray2[0] = Bitmap.Config.ARGB_8888;
            configArray = configArray2;
            configArray2[1] = Bitmap.Config.RGBA_F16;
        } else {
            Bitmap.Config[] configArray3 = new Bitmap.Config[1];
            configArray = configArray3;
            configArray3[0] = Bitmap.Config.ARGB_8888;
        }
        ARGB_8888_IN_CONFIGS = configArray;
        RGBA_F16_IN_CONFIGS = ARGB_8888_IN_CONFIGS;
        RGB_565_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.RGB_565};
        ARGB_4444_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_4444};
        ALPHA_8_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ALPHA_8};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcoil/bitmappool/strategy/SizeConfigStrategy$Key;", "", "size", "", "config", "Landroid/graphics/Bitmap$Config;", "(ILandroid/graphics/Bitmap$Config;)V", "getConfig", "()Landroid/graphics/Bitmap$Config;", "getSize", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "coil-base_release"})
    private static final class Key {
        private final int size;
        @NotNull
        private final Bitmap.Config config;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String toString() {
            void size$iv;
            Companion companion = Companion;
            int n = this.size;
            Bitmap.Config config$iv = this.config;
            boolean $i$f$getBitmapString = false;
            return "" + '[' + (int)size$iv + "](" + config$iv + ')';
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final Bitmap.Config getConfig() {
            return this.config;
        }

        public Key(int size2, @NotNull Bitmap.Config config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this.size = size2;
            this.config = config;
        }

        public final int component1() {
            return this.size;
        }

        @NotNull
        public final Bitmap.Config component2() {
            return this.config;
        }

        @NotNull
        public final Key copy(int size2, @NotNull Bitmap.Config config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            return new Key(size2, config);
        }

        public static /* synthetic */ Key copy$default(Key key, int n, Bitmap.Config config, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = key.size;
            }
            if ((n2 & 2) != 0) {
                config = key.config;
            }
            return key.copy(n, config);
        }

        public int hashCode() {
            Bitmap.Config config = this.config;
            return Integer.hashCode(this.size) * 31 + (config != null ? config.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Key)) break block3;
                    Key key = (Key)object;
                    if (this.size != key.size || !Intrinsics.areEqual((Object)this.config, (Object)key.config)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005H\u0082\bR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcoil/bitmappool/strategy/SizeConfigStrategy$Companion;", "", "()V", "ALPHA_8_IN_CONFIGS", "", "Landroid/graphics/Bitmap$Config;", "[Landroid/graphics/Bitmap$Config;", "ARGB_4444_IN_CONFIGS", "ARGB_8888_IN_CONFIGS", "MAX_SIZE_MULTIPLE", "", "RGBA_F16_IN_CONFIGS", "RGB_565_IN_CONFIGS", "getBitmapString", "", "size", "config", "coil-base_release"})
    public static final class Companion {
        private final String getBitmapString(int size2, Bitmap.Config config) {
            int $i$f$getBitmapString = 0;
            return "" + '[' + size2 + "](" + config + ')';
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getBitmapString(Companion $this, int size2, Bitmap.Config config) {
            return $this.getBitmapString(size2, config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

