/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import coil.decode.DecodeUtils;
import coil.memory.MemoryCache;
import coil.memory.RequestService;
import coil.request.Request;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import coil.size.SizeResolver;
import coil.util.ExtensionsKt;
import coil.util.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J:\u0010\u0015\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcoil/memory/MemoryCacheService;", "", "requestService", "Lcoil/memory/RequestService;", "logger", "Lcoil/util/Logger;", "(Lcoil/memory/RequestService;Lcoil/util/Logger;)V", "isCachedValueValid", "", "cacheKey", "Lcoil/memory/MemoryCache$Key;", "cacheValue", "Lcoil/memory/MemoryCache$Value;", "request", "Lcoil/request/Request;", "sizeResolver", "Lcoil/size/SizeResolver;", "size", "Lcoil/size/Size;", "scale", "Lcoil/size/Scale;", "isSizeValid", "Companion", "coil-base_release"})
public final class MemoryCacheService {
    private final RequestService requestService;
    private final Logger logger;
    private static final String TAG = "MemoryCacheService";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final boolean isCachedValueValid(@Nullable MemoryCache.Key cacheKey, @NotNull MemoryCache.Value cacheValue, @NotNull Request request, @NotNull SizeResolver sizeResolver, @NotNull Size size2, @NotNull Scale scale) {
        Intrinsics.checkParameterIsNotNull((Object)cacheValue, (String)"cacheValue");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)sizeResolver, (String)"sizeResolver");
        Intrinsics.checkParameterIsNotNull((Object)size2, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        if (!this.isSizeValid(cacheKey, cacheValue, request, sizeResolver, size2, scale)) {
            return false;
        }
        if (!this.requestService.isConfigValidForHardware(request, ExtensionsKt.getSafeConfig(cacheValue.getBitmap()))) {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 3;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var13_12 = tag$iv;
                    void var12_13 = $this$log$iv;
                    boolean bl = false;
                    String string2 = request.getData() + ": Cached bitmap is hardware-backed, which is incompatible with the request.";
                    var12_13.log((String)var13_12, n, string2, null);
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSizeValid(MemoryCache.Key cacheKey, MemoryCache.Value cacheValue, Request request, SizeResolver sizeResolver, Size size2, Scale scale) {
        Size size3 = size2;
        if (size3 instanceof OriginalSize) {
            if (cacheValue.isSampled()) {
                Logger logger = this.logger;
                if (logger != null) {
                    void $this$log$iv;
                    Logger logger2 = logger;
                    String string = TAG;
                    int priority$iv = 3;
                    boolean $i$f$log = false;
                    if ($this$log$iv.getLevel() <= priority$iv) {
                        void tag$iv;
                        int n = priority$iv;
                        void var18_22 = tag$iv;
                        void var17_25 = $this$log$iv;
                        boolean bl2 = false;
                        String string2 = request.getData() + ": Requested original size, but cached image is sampled.";
                        var17_25.log((String)var18_22, n, string2, null);
                    }
                }
                return false;
            }
        } else if (size3 instanceof PixelSize) {
            double multiple;
            Size cachedSize22;
            int cachedWidth = 0;
            int cachedHeight = 0;
            MemoryCache.Key key = cacheKey;
            Size size4 = cachedSize22 = key != null ? key.getSize() : null;
            if (cachedSize22 instanceof PixelSize) {
                cachedWidth = ((PixelSize)cachedSize22).getWidth();
                cachedHeight = ((PixelSize)cachedSize22).getHeight();
            } else if (Intrinsics.areEqual((Object)cachedSize22, (Object)OriginalSize.INSTANCE) || cachedSize22 == null) {
                Bitmap bitmap = cacheValue.getBitmap();
                cachedWidth = bitmap.getWidth();
                cachedHeight = bitmap.getHeight();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int cachedSize22 = cachedWidth - ((PixelSize)size2).getWidth();
            boolean bl = false;
            if (Math.abs(cachedSize22) <= 1) {
                cachedSize22 = cachedHeight - ((PixelSize)size2).getHeight();
                bl = false;
                if (Math.abs(cachedSize22) <= 1) {
                    return true;
                }
            }
            if ((multiple = DecodeUtils.computeSizeMultiplier(cachedWidth, cachedHeight, ((PixelSize)size2).getWidth(), ((PixelSize)size2).getHeight(), scale)) != 1.0 && !this.requestService.allowInexactSize(request, sizeResolver)) {
                Logger logger = this.logger;
                if (logger != null) {
                    void $this$log$iv;
                    Logger bl2 = logger;
                    String string = TAG;
                    int priority$iv = 3;
                    boolean $i$f$log = false;
                    if ($this$log$iv.getLevel() <= priority$iv) {
                        void tag$iv;
                        int n = priority$iv;
                        void var18_23 = tag$iv;
                        void var17_26 = $this$log$iv;
                        boolean bl3 = false;
                        String string3 = request.getData() + ": Cached image's request size (" + cachedWidth + ", " + cachedHeight + ") " + "does not exactly match the requested size (" + ((PixelSize)size2).getWidth() + ", " + ((PixelSize)size2).getHeight() + ", " + (Object)((Object)scale) + ").";
                        var17_26.log((String)var18_23, n, string3, null);
                    }
                }
                return false;
            }
            if (multiple > 1.0 && cacheValue.isSampled()) {
                Logger logger = this.logger;
                if (logger != null) {
                    Logger $this$log$iv = logger;
                    String tag$iv = TAG;
                    int priority$iv = 3;
                    boolean $i$f$log = false;
                    if ($this$log$iv.getLevel() <= priority$iv) {
                        int n = priority$iv;
                        String string = tag$iv;
                        Logger logger3 = $this$log$iv;
                        boolean bl4 = false;
                        String string4 = request.getData() + ": Cached image's request size (" + cachedWidth + ", " + cachedHeight + ") " + "is smaller than the requested size (" + ((PixelSize)size2).getWidth() + ", " + ((PixelSize)size2).getHeight() + ", " + (Object)((Object)scale) + ").";
                        logger3.log(string, n, string4, null);
                    }
                }
                return false;
            }
        }
        return true;
    }

    public MemoryCacheService(@NotNull RequestService requestService, @Nullable Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)requestService, (String)"requestService");
        this.requestService = requestService;
        this.logger = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/memory/MemoryCacheService$Companion;", "", "()V", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

