/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.widget.ImageView;
import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;
import androidx.lifecycle.Lifecycle;
import coil.DefaultRequestOptions;
import coil.decode.Options;
import coil.lifecycle.GlobalLifecycle;
import coil.lifecycle.LifecycleCoroutineDispatcher;
import coil.memory.HardwareBitmapService;
import coil.memory.RequestService$WhenMappings;
import coil.request.CachePolicy;
import coil.request.ErrorResult;
import coil.request.GetRequest;
import coil.request.LoadRequest;
import coil.request.NullRequestDataException;
import coil.request.Parameters;
import coil.request.Request;
import coil.size.DisplaySizeResolver;
import coil.size.Precision;
import coil.size.Scale;
import coil.size.Size;
import coil.size.SizeResolver;
import coil.size.ViewSizeResolver;
import coil.target.Target;
import coil.target.ViewTarget;
import coil.util.ContextsKt;
import coil.util.ExtensionsKt;
import coil.util.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0007J0\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nH\u0007J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u0004\u0018\u00010%*\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcoil/memory/RequestService;", "", "defaults", "Lcoil/DefaultRequestOptions;", "logger", "Lcoil/util/Logger;", "(Lcoil/DefaultRequestOptions;Lcoil/util/Logger;)V", "hardwareBitmapService", "Lcoil/memory/HardwareBitmapService;", "allowInexactSize", "", "request", "Lcoil/request/Request;", "sizeResolver", "Lcoil/size/SizeResolver;", "errorResult", "Lcoil/request/ErrorResult;", "throwable", "", "allowFake", "isConfigValidForHardware", "requestedConfig", "Landroid/graphics/Bitmap$Config;", "isConfigValidForHardwareAllocation", "size", "Lcoil/size/Size;", "isConfigValidForTransformations", "lifecycleInfo", "Lcoil/memory/RequestService$LifecycleInfo;", "options", "Lcoil/decode/Options;", "scale", "Lcoil/size/Scale;", "isOnline", "context", "Landroid/content/Context;", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "Lcoil/request/LoadRequest;", "Companion", "LifecycleInfo", "coil-base_release"})
public final class RequestService {
    private final HardwareBitmapService hardwareBitmapService;
    private final DefaultRequestOptions defaults;
    private final Logger logger;
    private static final ErrorResult FAKE_ERROR_RESULT;
    @JvmField
    @NotNull
    public static final Bitmap.Config[] VALID_TRANSFORMATION_CONFIGS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ErrorResult errorResult(@NotNull Request request, @NotNull Throwable throwable, boolean allowFake) {
        Drawable drawable;
        Request $this$fallbackOrDefault$iv;
        DefaultRequestOptions defaults$iv;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        if (request instanceof GetRequest && allowFake) {
            return FAKE_ERROR_RESULT;
        }
        if (throwable instanceof NullRequestDataException) {
            Request request2 = request;
            defaults$iv = this.defaults;
            boolean $i$f$fallbackOrDefault = false;
            drawable = $this$fallbackOrDefault$iv instanceof LoadRequest && $this$fallbackOrDefault$iv.getFallbackDrawable$coil_base_release() != null ? $this$fallbackOrDefault$iv.getFallback() : defaults$iv.getFallback();
        } else {
            void $this$errorOrDefault$iv;
            $this$fallbackOrDefault$iv = request;
            defaults$iv = this.defaults;
            boolean $i$f$errorOrDefault = false;
            drawable = $this$errorOrDefault$iv instanceof LoadRequest && $this$errorOrDefault$iv.getErrorDrawable$coil_base_release() != null ? $this$errorOrDefault$iv.getError() : defaults$iv.getError();
        }
        Drawable drawable2 = drawable;
        return new ErrorResult(drawable2, throwable);
    }

    @MainThread
    @NotNull
    public final LifecycleInfo lifecycleInfo(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Request request2 = request;
        if (!(request2 instanceof GetRequest)) {
            if (request2 instanceof LoadRequest) {
                LifecycleInfo lifecycleInfo;
                Lifecycle lifecycle = this.getLifecycle((LoadRequest)request);
                if (lifecycle != null) {
                    CoroutineDispatcher mainDispatcher = LifecycleCoroutineDispatcher.Companion.createUnlessStarted((CoroutineDispatcher)Dispatchers.getMain().getImmediate(), lifecycle);
                    lifecycleInfo = new LifecycleInfo(lifecycle, mainDispatcher);
                } else {
                    lifecycleInfo = LifecycleInfo.Companion.getGLOBAL();
                }
                return lifecycleInfo;
            }
            throw new NoWhenBranchMatchedException();
        }
        return LifecycleInfo.Companion.getGLOBAL();
    }

    @NotNull
    public final SizeResolver sizeResolver(@NotNull Request request, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SizeResolver sizeResolver = request.getSizeResolver();
        Target target2 = request.getTarget();
        return sizeResolver != null ? sizeResolver : (target2 instanceof ViewTarget ? (SizeResolver)ViewSizeResolver.Companion.create$default(ViewSizeResolver.Companion, ((ViewTarget)target2).getView(), false, 2, null) : (SizeResolver)new DisplaySizeResolver(context));
    }

    @NotNull
    public final Scale scale(@NotNull Request request, @NotNull SizeResolver sizeResolver) {
        Object view;
        Object view2;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)sizeResolver, (String)"sizeResolver");
        Scale scale = request.getScale();
        if (scale != null) {
            return scale;
        }
        if (sizeResolver instanceof ViewSizeResolver && (view2 = ((ViewSizeResolver)sizeResolver).getView()) instanceof ImageView) {
            return ExtensionsKt.getScale((ImageView)view2);
        }
        Target target2 = request.getTarget();
        if (target2 instanceof ViewTarget && (view = ((ViewTarget)target2).getView()) instanceof ImageView) {
            return ExtensionsKt.getScale((ImageView)view);
        }
        return Scale.FILL;
    }

    public final boolean allowInexactSize(@NotNull Request request, @NotNull SizeResolver sizeResolver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)sizeResolver, (String)"sizeResolver");
        Precision precision = request.getPrecision();
        if (precision == null) {
            precision = this.defaults.getPrecision();
        }
        switch (RequestService$WhenMappings.$EnumSwitchMapping$0[precision.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                Target target2 = request.getTarget();
                if (target2 instanceof ViewTarget && ((ViewTarget)target2).getView() instanceof ImageView && sizeResolver instanceof ViewSizeResolver && ((ViewSizeResolver)sizeResolver).getView() == ((ViewTarget)target2).getView()) {
                    return true;
                }
                return request.getSizeResolver() == null && sizeResolver instanceof DisplaySizeResolver;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public final Options options(@NotNull Request request, @NotNull SizeResolver sizeResolver, @NotNull Size size2, @NotNull Scale scale, boolean isOnline) {
        CachePolicy cachePolicy;
        CachePolicy cachePolicy2;
        Bitmap.Config config;
        boolean isValidConfig;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)sizeResolver, (String)"sizeResolver");
        Intrinsics.checkParameterIsNotNull((Object)size2, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        boolean bl = isValidConfig = this.isConfigValidForTransformations(request) && this.isConfigValidForHardwareAllocation(request, size2);
        if (isValidConfig) {
            void $this$bitmapConfigOrDefault$iv;
            Request request2 = request;
            DefaultRequestOptions defaults$iv = this.defaults;
            boolean $i$f$bitmapConfigOrDefault = false;
            config = $this$bitmapConfigOrDefault$iv.getBitmapConfig();
            if (config == null) {
                config = defaults$iv.getBitmapConfig();
            }
        } else {
            config = Bitmap.Config.ARGB_8888;
        }
        Bitmap.Config bitmapConfig = config;
        CachePolicy networkCachePolicy = isOnline ? request.getNetworkCachePolicy() : CachePolicy.DISABLED;
        Boolean bl2 = request.getAllowRgb565();
        boolean allowRgb565 = (bl2 != null ? bl2.booleanValue() : this.defaults.getAllowRgb565()) && request.getTransformations().isEmpty() && bitmapConfig != Bitmap.Config.ALPHA_8;
        ColorSpace colorSpace = request.getColorSpace();
        boolean bl3 = this.allowInexactSize(request, sizeResolver);
        Headers headers = request.getHeaders();
        Parameters parameters = request.getParameters();
        CachePolicy cachePolicy3 = request.getMemoryCachePolicy();
        if (cachePolicy3 == null) {
            cachePolicy3 = this.defaults.getMemoryCachePolicy();
        }
        if ((cachePolicy2 = request.getDiskCachePolicy()) == null) {
            cachePolicy2 = this.defaults.getDiskCachePolicy();
        }
        if ((cachePolicy = networkCachePolicy) == null) {
            cachePolicy = this.defaults.getNetworkCachePolicy();
        }
        return new Options(bitmapConfig, colorSpace, scale, bl3, allowRgb565, headers, parameters, cachePolicy3, cachePolicy2, cachePolicy);
    }

    public final boolean isConfigValidForHardware(@NotNull Request request, @NotNull Bitmap.Config requestedConfig) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)requestedConfig, (String)"requestedConfig");
        if (!ExtensionsKt.isHardware(requestedConfig)) {
            return true;
        }
        Boolean bl = request.getAllowHardware();
        if (!(bl != null ? bl.booleanValue() : this.defaults.getAllowHardware())) {
            return false;
        }
        Target target2 = request.getTarget();
        if (target2 instanceof ViewTarget) {
            Object t = ((ViewTarget)target2).getView();
            boolean bl2 = false;
            boolean bl3 = false;
            Object $this$run = t;
            boolean bl4 = false;
            if ($this$run.isAttachedToWindow() && !$this$run.isHardwareAccelerated()) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final boolean isConfigValidForHardwareAllocation(Request request, Size size2) {
        void $this$bitmapConfigOrDefault$iv;
        Request request2 = request;
        DefaultRequestOptions defaultRequestOptions = this.defaults;
        Request request3 = request;
        RequestService requestService = this;
        boolean $i$f$bitmapConfigOrDefault = false;
        Bitmap.Config config = $this$bitmapConfigOrDefault$iv.getBitmapConfig();
        if (config == null) {
            void defaults$iv;
            config = defaults$iv.getBitmapConfig();
        }
        Bitmap.Config config2 = config;
        return requestService.isConfigValidForHardware(request3, config2) && this.hardwareBitmapService.allowHardware(size2, this.logger);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConfigValidForTransformations(Request request) {
        void $this$bitmapConfigOrDefault$iv;
        if (request.getTransformations().isEmpty()) return true;
        Request request2 = request;
        DefaultRequestOptions defaultRequestOptions = this.defaults;
        Object[] objectArray = VALID_TRANSFORMATION_CONFIGS;
        boolean $i$f$bitmapConfigOrDefault = false;
        Bitmap.Config config = $this$bitmapConfigOrDefault$iv.getBitmapConfig();
        if (config == null) {
            void defaults$iv;
            config = defaults$iv.getBitmapConfig();
        }
        Bitmap.Config config2 = config;
        if (!ArraysKt.contains((Object[])objectArray, (Object)config2)) return false;
        return true;
    }

    private final Lifecycle getLifecycle(@NotNull LoadRequest $this$getLifecycle) {
        Lifecycle lifecycle;
        if ($this$getLifecycle.getLifecycle() != null) {
            lifecycle = $this$getLifecycle.getLifecycle();
        } else if ($this$getLifecycle.getTarget() instanceof ViewTarget) {
            Context context = ((ViewTarget)$this$getLifecycle.getTarget()).getView().getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"target.view.context");
            lifecycle = ContextsKt.getLifecycle(context);
        } else {
            lifecycle = ContextsKt.getLifecycle($this$getLifecycle.getContext());
        }
        return lifecycle;
    }

    public RequestService(@NotNull DefaultRequestOptions defaults, @Nullable Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)defaults, (String)"defaults");
        this.defaults = defaults;
        this.logger = logger;
        this.hardwareBitmapService = HardwareBitmapService.Companion.invoke();
    }

    static {
        Bitmap.Config[] configArray;
        Companion = new Companion(null);
        FAKE_ERROR_RESULT = new ErrorResult(null, new Exception());
        if (Build.VERSION.SDK_INT >= 26) {
            Bitmap.Config[] configArray2 = new Bitmap.Config[2];
            configArray2[0] = Bitmap.Config.ARGB_8888;
            configArray = configArray2;
            configArray2[1] = Bitmap.Config.RGBA_F16;
        } else {
            Bitmap.Config[] configArray3 = new Bitmap.Config[1];
            configArray = configArray3;
            configArray3[0] = Bitmap.Config.ARGB_8888;
        }
        VALID_TRANSFORMATION_CONFIGS = configArray;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcoil/memory/RequestService$LifecycleInfo;", "", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "mainDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Landroidx/lifecycle/Lifecycle;Lkotlinx/coroutines/CoroutineDispatcher;)V", "getLifecycle", "()Landroidx/lifecycle/Lifecycle;", "getMainDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "coil-base_release"})
    public static final class LifecycleInfo {
        @NotNull
        private final Lifecycle lifecycle;
        @NotNull
        private final CoroutineDispatcher mainDispatcher;
        @NotNull
        private static final LifecycleInfo GLOBAL;
        public static final Companion Companion;

        @NotNull
        public final Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        @NotNull
        public final CoroutineDispatcher getMainDispatcher() {
            return this.mainDispatcher;
        }

        public LifecycleInfo(@NotNull Lifecycle lifecycle, @NotNull CoroutineDispatcher mainDispatcher) {
            Intrinsics.checkParameterIsNotNull((Object)lifecycle, (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)mainDispatcher, (String)"mainDispatcher");
            this.lifecycle = lifecycle;
            this.mainDispatcher = mainDispatcher;
        }

        static {
            Companion = new Companion(null);
            GLOBAL = new LifecycleInfo(GlobalLifecycle.INSTANCE, (CoroutineDispatcher)Dispatchers.getMain().getImmediate());
        }

        @NotNull
        public final Lifecycle component1() {
            return this.lifecycle;
        }

        @NotNull
        public final CoroutineDispatcher component2() {
            return this.mainDispatcher;
        }

        @NotNull
        public final LifecycleInfo copy(@NotNull Lifecycle lifecycle, @NotNull CoroutineDispatcher mainDispatcher) {
            Intrinsics.checkParameterIsNotNull((Object)lifecycle, (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)mainDispatcher, (String)"mainDispatcher");
            return new LifecycleInfo(lifecycle, mainDispatcher);
        }

        public static /* synthetic */ LifecycleInfo copy$default(LifecycleInfo lifecycleInfo, Lifecycle lifecycle, CoroutineDispatcher coroutineDispatcher, int n, Object object) {
            if ((n & 1) != 0) {
                lifecycle = lifecycleInfo.lifecycle;
            }
            if ((n & 2) != 0) {
                coroutineDispatcher = lifecycleInfo.mainDispatcher;
            }
            return lifecycleInfo.copy(lifecycle, coroutineDispatcher);
        }

        @NotNull
        public String toString() {
            return "LifecycleInfo(lifecycle=" + this.lifecycle + ", mainDispatcher=" + this.mainDispatcher + ")";
        }

        public int hashCode() {
            Lifecycle lifecycle = this.lifecycle;
            CoroutineDispatcher coroutineDispatcher = this.mainDispatcher;
            return (lifecycle != null ? lifecycle.hashCode() : 0) * 31 + (coroutineDispatcher != null ? coroutineDispatcher.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LifecycleInfo)) break block3;
                    LifecycleInfo lifecycleInfo = (LifecycleInfo)object;
                    if (!Intrinsics.areEqual((Object)this.lifecycle, (Object)lifecycleInfo.lifecycle) || !Intrinsics.areEqual((Object)this.mainDispatcher, (Object)lifecycleInfo.mainDispatcher)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcoil/memory/RequestService$LifecycleInfo$Companion;", "", "()V", "GLOBAL", "Lcoil/memory/RequestService$LifecycleInfo;", "getGLOBAL", "()Lcoil/memory/RequestService$LifecycleInfo;", "coil-base_release"})
        public static final class Companion {
            @NotNull
            public final LifecycleInfo getGLOBAL() {
                return GLOBAL;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0000X\u0081\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcoil/memory/RequestService$Companion;", "", "()V", "FAKE_ERROR_RESULT", "Lcoil/request/ErrorResult;", "VALID_TRANSFORMATION_CONFIGS", "", "Landroid/graphics/Bitmap$Config;", "[Landroid/graphics/Bitmap$Config;", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

