/*
 * Decompiled with CFR 0.152.
 */
package coil.transform;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import androidx.annotation.RequiresApi;
import coil.bitmappool.BitmapPool;
import coil.size.Size;
import coil.transform.Transformation;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcoil/transform/BlurTransformation;", "Lcoil/transform/Transformation;", "context", "Landroid/content/Context;", "radius", "", "sampling", "(Landroid/content/Context;FF)V", "key", "", "transform", "Landroid/graphics/Bitmap;", "pool", "Lcoil/bitmappool/BitmapPool;", "input", "size", "Lcoil/size/Size;", "(Lcoil/bitmappool/BitmapPool;Landroid/graphics/Bitmap;Lcoil/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "coil-base_release"})
@RequiresApi(value=18)
public final class BlurTransformation
implements Transformation {
    private final Context context;
    private final float radius;
    private final float sampling;
    private static final float DEFAULT_RADIUS = 10.0f;
    private static final float DEFAULT_SAMPLING = 1.0f;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String key() {
        return BlurTransformation.class.getName() + '-' + this.radius + '-' + this.sampling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object transform(@NotNull BitmapPool pool, @NotNull Bitmap input, @NotNull Size size2, @NotNull Continuation<? super Bitmap> $completion) {
        RenderScript renderScript;
        Canvas c$iv;
        Bitmap output;
        Paint paint = new Paint(3);
        int scaledWidth = (int)((float)input.getWidth() / this.sampling);
        int scaledHeight = (int)((float)input.getHeight() / this.sampling);
        Bitmap $this$applyCanvas$iv = output = pool.get(scaledWidth, scaledHeight, ExtensionsKt.getSafeConfig(input));
        boolean $i$f$applyCanvas = false;
        Canvas $this$applyCanvas = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$applyCanvas.scale(1.0f / this.sampling, 1.0f / this.sampling);
        $this$applyCanvas.drawBitmap(input, 0.0f, 0.0f, paint);
        RenderScript script = null;
        Allocation tmpInt = null;
        Allocation tmpOut = null;
        ScriptIntrinsicBlur blur = null;
        try {
            script = RenderScript.create((Context)this.context);
            Allocation allocation = tmpInt = Allocation.createFromBitmap((RenderScript)script, (Bitmap)output, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            Intrinsics.checkExpressionValueIsNotNull((Object)allocation, (String)"tmpInt");
            tmpOut = Allocation.createTyped((RenderScript)script, (Type)allocation.getType());
            blur = ScriptIntrinsicBlur.create((RenderScript)script, (Element)Element.U8_4((RenderScript)script));
            blur.setRadius(this.radius);
            blur.setInput(tmpInt);
            blur.forEach(tmpOut);
            tmpOut.copyTo(output);
            renderScript = script;
        }
        catch (Throwable throwable) {
            RenderScript renderScript2 = script;
            if (renderScript2 != null) {
                renderScript2.destroy();
            }
            Allocation allocation = tmpInt;
            if (allocation != null) {
                allocation.destroy();
            }
            Allocation allocation2 = tmpOut;
            if (allocation2 != null) {
                allocation2.destroy();
            }
            ScriptIntrinsicBlur scriptIntrinsicBlur = blur;
            if (scriptIntrinsicBlur != null) {
                scriptIntrinsicBlur.destroy();
            }
            throw throwable;
        }
        if (renderScript != null) {
            renderScript.destroy();
        }
        tmpInt.destroy();
        Allocation allocation = tmpOut;
        if (allocation != null) {
            allocation.destroy();
        }
        ScriptIntrinsicBlur scriptIntrinsicBlur = blur;
        if (scriptIntrinsicBlur != null) {
            scriptIntrinsicBlur.destroy();
        }
        pool.put(input);
        return output;
    }

    @JvmOverloads
    public BlurTransformation(@NotNull Context context, float radius, float sampling) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.radius = radius;
        this.sampling = sampling;
        double d = this.radius;
        boolean bl = d >= 0.0 && d <= 25.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "radius must be in [0, 25].";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.sampling > 0.0f;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "sampling must be > 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ BlurTransformation(Context context, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 10.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        this(context, f, f2);
    }

    @JvmOverloads
    public BlurTransformation(@NotNull Context context, float radius) {
        this(context, radius, 0.0f, 4, null);
    }

    @JvmOverloads
    public BlurTransformation(@NotNull Context context) {
        this(context, 0.0f, 0.0f, 6, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcoil/transform/BlurTransformation$Companion;", "", "()V", "DEFAULT_RADIUS", "", "DEFAULT_SAMPLING", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

