/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.StatFs;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import coil.util.ExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcoil/util/Utils;", "", "()V", "CACHE_DIRECTORY_NAME", "", "DISK_CACHE_PERCENTAGE", "", "LOW_MEMORY_MULTIPLIER", "MAX_DISK_CACHE_SIZE", "", "MIN_DISK_CACHE_SIZE", "STANDARD_MULTIPLIER", "calculateAllocationByteCount", "", "width", "height", "config", "Landroid/graphics/Bitmap$Config;", "calculateAvailableMemorySize", "context", "Landroid/content/Context;", "percentage", "calculateDiskCacheSize", "cacheDirectory", "Ljava/io/File;", "getDefaultAvailableMemoryPercentage", "getDefaultBitmapConfig", "getDefaultBitmapPoolPercentage", "getDefaultCacheDirectory", "coil-base_release"})
public final class Utils {
    private static final String CACHE_DIRECTORY_NAME = "image_cache";
    private static final long MIN_DISK_CACHE_SIZE = 0xA00000L;
    private static final long MAX_DISK_CACHE_SIZE = 0xFA00000L;
    private static final double DISK_CACHE_PERCENTAGE = 0.02;
    private static final double STANDARD_MULTIPLIER = 0.25;
    private static final double LOW_MEMORY_MULTIPLIER = 0.15;
    public static final Utils INSTANCE;

    public final int calculateAllocationByteCount(@Px int width, @Px int height, @Nullable Bitmap.Config config) {
        return width * height * ExtensionsKt.getBytesPerPixel(config);
    }

    @NotNull
    public final File getDefaultCacheDirectory(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File file = new File(context.getCacheDir(), CACHE_DIRECTORY_NAME);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.mkdirs();
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public final long calculateDiskCacheSize(@NotNull File cacheDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)cacheDirectory, (String)"cacheDirectory");
        try {
            void $this$getBlockSizeCompat$iv;
            StatFs $this$getBlockCountCompat$iv;
            StatFs cacheDir;
            StatFs statFs = cacheDir = new StatFs(cacheDirectory.getAbsolutePath());
            double d = 0.02;
            boolean $i$f$getBlockCountCompat = false;
            long l = Build.VERSION.SDK_INT > 18 ? $this$getBlockCountCompat$iv.getBlockCountLong() : (long)$this$getBlockCountCompat$iv.getBlockCount();
            $this$getBlockCountCompat$iv = cacheDir;
            d *= (double)l;
            boolean $i$f$getBlockSizeCompat = false;
            l = Build.VERSION.SDK_INT > 18 ? $this$getBlockSizeCompat$iv.getBlockSizeLong() : (long)$this$getBlockSizeCompat$iv.getBlockSize();
            double size2 = d * (double)l;
            return RangesKt.coerceIn((long)((long)size2), (long)0xA00000L, (long)0xFA00000L);
        }
        catch (Exception _) {
            long l = 0xA00000L;
            return l;
        }
    }

    public final long calculateAvailableMemorySize(@NotNull Context context, double percentage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context $this$requireSystemService$iv = context;
        boolean $i$f$requireSystemService = false;
        Context $this$getSystemService$iv$iv = $this$requireSystemService$iv;
        boolean $i$f$getSystemService = false;
        Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv$iv, ActivityManager.class);
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) {
            boolean bl3 = false;
            String string = "System service of type " + ActivityManager.class + " was not found.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ActivityManager activityManager = (ActivityManager)object;
        boolean isLargeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClassMegabytes = isLargeHeap ? activityManager.getLargeMemoryClass() : activityManager.getMemoryClass();
        return (long)(percentage * (double)memoryClassMegabytes * (double)1024 * (double)1024);
    }

    public final double getDefaultAvailableMemoryPercentage(@NotNull Context context) {
        ActivityManager activityManager;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context $this$requireSystemService$iv = context;
        boolean $i$f$requireSystemService = false;
        Context $this$getSystemService$iv$iv = $this$requireSystemService$iv;
        boolean $i$f$getSystemService = false;
        Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv$iv, ActivityManager.class);
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) {
            boolean bl3 = false;
            String string = "System service of type " + ActivityManager.class + " was not found.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ActivityManager $this$isLowRamDeviceCompat$iv = activityManager = (ActivityManager)object;
        boolean $i$f$isLowRamDeviceCompat = false;
        return Build.VERSION.SDK_INT < 19 || $this$isLowRamDeviceCompat$iv.isLowRamDevice() ? 0.15 : 0.25;
    }

    public final double getDefaultBitmapPoolPercentage() {
        int n = Build.VERSION.SDK_INT;
        return 19 <= n && 25 >= n ? 0.5 : 0.25;
    }

    @NotNull
    public final Bitmap.Config getDefaultBitmapConfig() {
        return Build.VERSION.SDK_INT >= 26 ? Bitmap.Config.HARDWARE : Bitmap.Config.ARGB_8888;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

