/*
 * Decompiled with CFR 0.152.
 */
package coil;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import coil.ComponentRegistry;
import coil.DefaultRequestOptions;
import coil.ImageLoader;
import coil.RealImageLoader;
import coil.util.ContextsKt;
import coil.util.Utils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import okhttp3.Cache;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0005\u001a\u00020\u00002\b\b\u0001\u0010\u0016\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\b\b\u0001\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u000bH\u0002J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u001a\u001a\u00020\u00002\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0086\bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u00002\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010\"\u001a\u00020\u00002\b\b\u0001\u0010%\u001a\u00020\u001fJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000bJ\u001f\u0010\n\u001a\u00020\u00002\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010J\u0010\u0010'\u001a\u00020\u00002\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010'\u001a\u00020\u00002\b\b\u0001\u0010%\u001a\u00020\u001fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r\u00a2\u0006\u0002\b\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcoil/ImageLoaderBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "availableMemoryPercentage", "", "bitmapPoolPercentage", "defaults", "Lcoil/DefaultRequestOptions;", "okHttpClient", "Lokhttp3/OkHttpClient;", "okHttpClientBuilder", "Lkotlin/Function1;", "Lokhttp3/OkHttpClient$Builder;", "", "Lkotlin/ExtensionFunctionType;", "registry", "Lcoil/ComponentRegistry;", "allowRgb565", "enable", "", "multiplier", "build", "Lcoil/ImageLoader;", "buildDefaultOkHttpClient", "componentRegistry", "builder", "Lcoil/ComponentRegistry$Builder;", "crossfade", "durationMillis", "", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "error", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableResId", "client", "placeholder", "coil-base_release"})
public final class ImageLoaderBuilder {
    private OkHttpClient okHttpClient;
    private Function1<? super OkHttpClient.Builder, Unit> okHttpClientBuilder;
    private ComponentRegistry registry;
    private double availableMemoryPercentage;
    private double bitmapPoolPercentage;
    private DefaultRequestOptions defaults;
    private final Context context;

    @NotNull
    public final ImageLoaderBuilder okHttpClient(@NotNull OkHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.okHttpClient = client;
        $this$apply.okHttpClientBuilder = null;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder okHttpClient(@NotNull Function1<? super OkHttpClient.Builder, Unit> builder) {
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.okHttpClientBuilder = builder;
        $this$apply.okHttpClient = null;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder componentRegistry(@NotNull Function1<? super ComponentRegistry.Builder, Unit> builder) {
        int $i$f$componentRegistry = 0;
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        ComponentRegistry.Companion companion = ComponentRegistry.Companion;
        ImageLoaderBuilder imageLoaderBuilder2 = $this$apply;
        boolean $i$f$invoke = false;
        ComponentRegistry.Builder builder2 = new ComponentRegistry.Builder();
        boolean bl4 = false;
        boolean bl5 = false;
        builder.invoke((Object)builder2);
        ComponentRegistry componentRegistry = builder2.build();
        imageLoaderBuilder2.componentRegistry(componentRegistry);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder componentRegistry(@NotNull ComponentRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.registry = registry;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder availableMemoryPercentage(@FloatRange(from=0.0, to=1.0) double multiplier) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        double d = multiplier;
        boolean bl4 = d >= 0.0 && d <= 1.0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Multiplier must be within the range [0.0, 1.0].";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$apply.availableMemoryPercentage = multiplier;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder bitmapPoolPercentage(@FloatRange(from=0.0, to=1.0) double multiplier) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        double d = multiplier;
        boolean bl4 = d >= 0.0 && d <= 1.0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Multiplier must be within the range [0.0, 1.0].";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$apply.bitmapPoolPercentage = multiplier;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, dispatcher, false, 0, null, null, 30, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder allowRgb565(boolean enable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, enable, 0, null, null, 29, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder crossfade(boolean enable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, enable ? 100 : 0, null, null, 27, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder crossfade(int durationMillis) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        boolean bl4 = durationMillis >= 0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Duration must be >= 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, durationMillis, null, null, 27, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder placeholder(@DrawableRes int drawableResId) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, 0, ContextsKt.getDrawableCompat($this$apply.context, drawableResId), null, 23, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder placeholder(@Nullable Drawable drawable2) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, 0, drawable2, null, 23, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder error(@DrawableRes int drawableResId) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, 0, null, ContextsKt.getDrawableCompat($this$apply.context, drawableResId), 15, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder error(@Nullable Drawable drawable2) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, 0, null, drawable2, 15, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoader build() {
        ComponentRegistry componentRegistry;
        long availableMemorySize = Utils.INSTANCE.calculateAvailableMemorySize(this.context, this.availableMemoryPercentage);
        long bitmapPoolSize = (long)(this.bitmapPoolPercentage * (double)availableMemorySize);
        int memoryCacheSize = (int)(availableMemorySize - bitmapPoolSize);
        Context context = this.context;
        DefaultRequestOptions defaultRequestOptions = this.defaults;
        long l = bitmapPoolSize;
        int n = memoryCacheSize;
        OkHttpClient okHttpClient = this.okHttpClient;
        if (okHttpClient == null) {
            okHttpClient = this.buildDefaultOkHttpClient();
        }
        if ((componentRegistry = this.registry) == null) {
            ComponentRegistry.Companion companion = ComponentRegistry.Companion;
            OkHttpClient okHttpClient2 = okHttpClient;
            int n2 = n;
            long l2 = l;
            DefaultRequestOptions defaultRequestOptions2 = defaultRequestOptions;
            Context context2 = context;
            boolean $i$f$invoke = false;
            ComponentRegistry.Builder builder = new ComponentRegistry.Builder();
            boolean bl = false;
            boolean bl2 = false;
            ComponentRegistry.Builder $receiver = builder;
            ComponentRegistry componentRegistry2 = builder.build();
            context = context2;
            defaultRequestOptions = defaultRequestOptions2;
            l = l2;
            n = n2;
            okHttpClient = okHttpClient2;
            componentRegistry = componentRegistry2;
        }
        ComponentRegistry componentRegistry3 = componentRegistry;
        OkHttpClient okHttpClient3 = okHttpClient;
        int n3 = n;
        long l3 = l;
        DefaultRequestOptions defaultRequestOptions3 = defaultRequestOptions;
        Context context3 = context;
        return new RealImageLoader(context3, defaultRequestOptions3, l3, n3, okHttpClient3, componentRegistry3);
    }

    private final OkHttpClient buildDefaultOkHttpClient() {
        File cacheDirectory = Utils.INSTANCE.getDefaultCacheDirectory(this.context);
        long cacheSize = Utils.INSTANCE.calculateDiskCacheSize(cacheDirectory);
        Cache cache2 = new Cache(cacheDirectory, cacheSize);
        Dispatcher dispatcher = new Dispatcher();
        boolean bl = false;
        boolean bl2 = false;
        Dispatcher $this$apply = dispatcher;
        boolean bl3 = false;
        $this$apply.setMaxRequestsPerHost($this$apply.getMaxRequests());
        Dispatcher dispatcher2 = dispatcher;
        dispatcher = new OkHttpClient.Builder().cache(cache2).dispatcher(dispatcher2);
        bl = false;
        bl2 = false;
        $this$apply = dispatcher;
        boolean bl4 = false;
        Function1<? super OkHttpClient.Builder, Unit> function1 = this.okHttpClientBuilder;
        if (function1 != null) {
            Dispatcher dispatcher3 = $this$apply;
            Intrinsics.checkExpressionValueIsNotNull((Object)dispatcher3, (String)"this");
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)dispatcher3);
        }
        OkHttpClient okHttpClient = dispatcher.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"OkHttpClient.Builder()\n \u2026s) }\n            .build()");
        return okHttpClient;
    }

    public ImageLoaderBuilder(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.availableMemoryPercentage = Utils.INSTANCE.getDefaultAvailableMemoryPercentage(this.context);
        this.bitmapPoolPercentage = Utils.INSTANCE.getDefaultBitmapPoolPercentage();
        this.defaults = new DefaultRequestOptions(null, false, 0, null, null, 31, null);
    }
}

