/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import androidx.annotation.Px;
import coil.decode.DecodeUtils$WhenMappings;
import coil.size.Scale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcoil/decode/DecodeUtils;", "", "()V", "GIF_HEADER", "Lokio/ByteString;", "WEBP_HEADER_RIFF", "WEBP_HEADER_VPX8", "WEBP_HEADER_WEBP", "calculateInSampleSize", "", "inWidth", "inHeight", "outWidth", "outHeight", "scale", "Lcoil/size/Scale;", "isAnimatedWebP", "", "source", "Lokio/BufferedSource;", "isGif", "isWebP", "coil-base_release"})
public final class DecodeUtils {
    private static final ByteString GIF_HEADER;
    private static final ByteString WEBP_HEADER_RIFF;
    private static final ByteString WEBP_HEADER_WEBP;
    private static final ByteString WEBP_HEADER_VPX8;
    public static final DecodeUtils INSTANCE;

    @JvmStatic
    public static final boolean isGif(@NotNull BufferedSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return source.rangeEquals(0L, GIF_HEADER);
    }

    @JvmStatic
    public static final boolean isWebP(@NotNull BufferedSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return source.rangeEquals(0L, WEBP_HEADER_RIFF) && source.rangeEquals(8L, WEBP_HEADER_WEBP);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isAnimatedWebP(@NotNull BufferedSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!DecodeUtils.isWebP(source)) return false;
        if (!source.rangeEquals(12L, WEBP_HEADER_VPX8)) return false;
        if (!source.request(17L)) return false;
        byte by = source.getBuffer().getByte(16L);
        int n = 2;
        boolean bl = false;
        if ((byte)(by & n) <= 0) return false;
        return true;
    }

    @JvmStatic
    public static final int calculateInSampleSize(@Px int inWidth, @Px int inHeight, @Px int outWidth, @Px int outHeight, @NotNull Scale scale) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        int n2 = 1;
        int n3 = Integer.highestOneBit(inWidth / outWidth);
        int n4 = 0;
        int widthInSampleSize = Math.max(n2, n3);
        n3 = 1;
        n4 = Integer.highestOneBit(inHeight / outHeight);
        boolean bl = false;
        int heightInSampleSize = Math.max(n3, n4);
        switch (DecodeUtils$WhenMappings.$EnumSwitchMapping$0[scale.ordinal()]) {
            case 1: {
                n3 = 0;
                n = Math.min(widthInSampleSize, heightInSampleSize);
                break;
            }
            case 2: {
                n3 = 0;
                n = Math.max(widthInSampleSize, heightInSampleSize);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private DecodeUtils() {
    }

    static {
        DecodeUtils decodeUtils;
        INSTANCE = decodeUtils = new DecodeUtils();
        GIF_HEADER = ByteString.Companion.encodeUtf8("GIF");
        WEBP_HEADER_RIFF = ByteString.Companion.encodeUtf8("RIFF");
        WEBP_HEADER_WEBP = ByteString.Companion.encodeUtf8("WEBP");
        WEBP_HEADER_VPX8 = ByteString.Companion.encodeUtf8("VP8X");
    }
}

