/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001+B3\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J \u0010 \u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013H\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0012\u0010&\u001a\u00020\n2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010\u0004\u001a\u00020\nH\u0016J\b\u0010)\u001a\u00020\nH\u0016J\u0018\u0010*\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcoil/drawable/CrossfadeDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "Landroid/graphics/drawable/Animatable;", "start", "end", "duration", "", "onEnd", "Lkotlin/Function0;", "", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;ILkotlin/jvm/functions/Function0;)V", "getEnd", "()Landroid/graphics/drawable/Drawable;", "isDone", "", "isRunning", "maxAlpha", "startTimeMillis", "", "draw", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "invalidateDrawable", "who", "markDone", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "scheduleDrawable", "what", "Ljava/lang/Runnable;", "when", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "stop", "unscheduleDrawable", "Companion", "coil-base_release"})
public final class CrossfadeDrawable
extends Drawable
implements Drawable.Callback,
Animatable {
    private long startTimeMillis;
    private int maxAlpha;
    private boolean isDone;
    private boolean isRunning;
    private Drawable start;
    @NotNull
    private final Drawable end;
    private final int duration;
    private final Function0<Unit> onEnd;
    public static final int DEFAULT_DURATION = 100;
    public static final Companion Companion = new Companion(null);

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (!this.isRunning || this.isDone) {
            this.start = null;
            this.end.setAlpha(this.maxAlpha);
            this.end.draw(canvas);
            return;
        }
        double percent = (double)(SystemClock.uptimeMillis() - this.startTimeMillis) / (double)this.duration;
        int alpha = (int)(RangesKt.coerceIn((double)percent, (double)0.0, (double)1.0) * (double)this.maxAlpha);
        if (alpha == this.maxAlpha) {
            this.end.setAlpha(this.maxAlpha);
            this.end.draw(canvas);
            this.markDone();
        } else {
            Drawable drawable2 = this.start;
            if (drawable2 != null) {
                Drawable drawable3 = drawable2;
                boolean bl = false;
                boolean bl2 = false;
                Drawable $this$apply = drawable3;
                boolean bl3 = false;
                $this$apply.setAlpha(this.maxAlpha);
                $this$apply.draw(canvas);
            }
            this.end.setAlpha(alpha);
            this.end.draw(canvas);
            this.invalidateSelf();
        }
    }

    public void setAlpha(int alpha) {
        int n = alpha;
        n = 0 <= n && 255 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Invalid alpha: " + alpha;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxAlpha = alpha;
    }

    public int getOpacity() {
        Drawable start = this.start;
        return this.isRunning && start != null ? Drawable.resolveOpacity((int)start.getOpacity(), (int)this.end.getOpacity()) : this.end.getOpacity();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Drawable drawable2 = this.start;
        if (drawable2 != null) {
            drawable2.setColorFilter(colorFilter);
        }
        this.end.setColorFilter(colorFilter);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        Drawable drawable2 = this.start;
        if (drawable2 != null) {
            drawable2.setBounds(bounds);
        }
        this.end.setBounds(bounds);
    }

    public int getIntrinsicWidth() {
        int n;
        Drawable start = this.start;
        if (this.isRunning && start != null) {
            int n2 = start.getIntrinsicWidth();
            int n3 = this.end.getIntrinsicWidth();
            boolean bl = false;
            n = Math.max(n2, n3);
        } else {
            n = this.end.getIntrinsicWidth();
        }
        return n;
    }

    public int getIntrinsicHeight() {
        int n;
        Drawable start = this.start;
        if (this.isRunning && start != null) {
            int n2 = start.getIntrinsicHeight();
            int n3 = this.end.getIntrinsicHeight();
            boolean bl = false;
            n = Math.max(n2, n3);
        } else {
            n = this.end.getIntrinsicHeight();
        }
        return n;
    }

    public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        this.scheduleSelf(what, when);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        Drawable drawable2;
        if (this.isRunning || this.isDone) {
            return;
        }
        this.isRunning = true;
        this.startTimeMillis = SystemClock.uptimeMillis();
        Drawable drawable3 = this.start;
        if (!(drawable3 instanceof Animatable)) {
            drawable3 = null;
        }
        Animatable animatable = (Animatable)drawable3;
        if (animatable != null) {
            animatable.start();
        }
        if (!((drawable2 = this.end) instanceof Animatable)) {
            drawable2 = null;
        }
        Animatable animatable2 = (Animatable)drawable2;
        if (animatable2 != null) {
            animatable2.start();
        }
        this.invalidateSelf();
    }

    public void stop() {
        Drawable drawable2;
        Drawable drawable3 = this.start;
        if (!(drawable3 instanceof Animatable)) {
            drawable3 = null;
        }
        Animatable animatable = (Animatable)drawable3;
        if (animatable != null) {
            animatable.stop();
        }
        if (!((drawable2 = this.end) instanceof Animatable)) {
            drawable2 = null;
        }
        Animatable animatable2 = (Animatable)drawable2;
        if (animatable2 != null) {
            animatable2.stop();
        }
        if (!this.isDone) {
            this.markDone();
        }
    }

    private final void markDone() {
        block0: {
            this.isDone = true;
            this.isRunning = false;
            this.start = null;
            Function0<Unit> function0 = this.onEnd;
            if (function0 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
    }

    @NotNull
    public final Drawable getEnd() {
        return this.end;
    }

    public CrossfadeDrawable(@Nullable Drawable start, @NotNull Drawable end, int duration, @Nullable Function0<Unit> onEnd) {
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        this.start = start;
        this.end = end;
        this.duration = duration;
        this.onEnd = onEnd;
        this.maxAlpha = 255;
        Drawable drawable2 = this.start;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
        this.end.setCallback((Drawable.Callback)this);
    }

    public /* synthetic */ CrossfadeDrawable(Drawable drawable2, Drawable drawable3, int n, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        if ((n2 & 8) != 0) {
            function0 = null;
        }
        this(drawable2, drawable3, n, (Function0<Unit>)function0);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/drawable/CrossfadeDrawable$Companion;", "", "()V", "DEFAULT_DURATION", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

